/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.listener;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.platform.annotations.gwt.client.AnnotationFrameApplication;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationDefinition;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.AnnotationUtils;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Utils;

public class AnnotationPopupEventListener
implements EventListener {
    private static final Map<Annotation, AnnotationPopupEventListener> LISTENERS = new HashMap<Annotation, AnnotationPopupEventListener>();
    private final Annotation annotation;
    private final AnnotationController controller;
    private final AnnotationPopup annotationPopup;
    private boolean enabled = true;
    private final Timer timer = new Timer(){

        public void run() {
            AnnotationPopupEventListener.this.annotationPopup.hide();
        }
    };

    public static AnnotationPopupEventListener getAnnotationPopupEventListener(Annotation annotation, AnnotationController controller) {
        AnnotationPopupEventListener listener = LISTENERS.get(annotation);
        if (listener == null) {
            listener = new AnnotationPopupEventListener(annotation, controller);
            LISTENERS.put(annotation, listener);
            controller.registerAnnotationPopupListener(listener);
        }
        return listener;
    }

    private AnnotationPopupEventListener(Annotation annotation, AnnotationController controller) {
        this.annotation = annotation;
        this.controller = controller;
        this.annotationPopup = new AnnotationPopup();
        this.annotationPopup.setStyleName("annotationsPopupEvent");
    }

    private void onEvent(Event event) {
        if (this.annotation == null || this.controller == null || !this.enabled) {
            AnnotationFrameApplication.getMainEventListener().onBrowserEvent(event);
            return;
        }
        if (event.getTypeInt() == 16) {
            if (!this.annotationPopup.isShown()) {
                this.annotationPopup.setPopupPosition(event.getClientX() + Window.getScrollLeft(), event.getClientY() + Window.getScrollTop());
                this.annotationPopup.show();
            }
            this.timer.cancel();
        } else if (event.getTypeInt() == 32) {
            this.timer.schedule(1000);
        }
    }

    public void onBrowserEvent(Event event) {
        this.onEvent(event);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    private class AnnotationPopup
    extends PopupPanel {
        private boolean showing = false;

        public AnnotationPopup() {
            this.createPopup();
        }

        private void createPopup() {
            VerticalPanel shownAnnotation = new VerticalPanel();
            shownAnnotation.addStyleName("annotation-mousover");
            HorizontalPanel horizontalPanel = new HorizontalPanel();
            if (AnnotationPopupEventListener.this.controller == null) {
                return;
            }
            AnnotationDefinition def = AnnotationPopupEventListener.this.controller.getWebConfiguration().getAnnotationDefinition(AnnotationPopupEventListener.this.annotation.getShortType());
            Image image = new Image(Utils.getBaseHref() + def.getIcon());
            horizontalPanel.add((Widget)image);
            horizontalPanel.add((Widget)new Label(AnnotationPopupEventListener.this.annotation.getFormattedDate()));
            Set<String> displayedFields = AnnotationPopupEventListener.this.controller.getWebConfiguration().getDisplayedFields();
            for (String displayedField : displayedFields) {
                String value = AnnotationPopupEventListener.this.annotation.getFields().get(displayedField);
                horizontalPanel.add((Widget)new Label("\u2022"));
                horizontalPanel.add((Widget)new Label(value != null ? value : " "));
            }
            shownAnnotation.add((Widget)horizontalPanel);
            if (AnnotationPopupEventListener.this.annotation.isBodyUrl()) {
                Frame frame = new Frame();
                frame.setUrl(AnnotationPopupEventListener.this.annotation.getBody());
                shownAnnotation.add((Widget)frame);
            } else {
                String text = AnnotationPopupEventListener.this.annotation.getBody();
                text = AnnotationUtils.replaceCarriageReturns(text);
                HTML label = new HTML(text);
                label.setStyleName("annotation-body");
                shownAnnotation.add((Widget)label);
            }
            DockPanel dockPanel = new DockPanel();
            dockPanel.add((Widget)shownAnnotation, DockPanel.CENTER);
            this.add((Widget)dockPanel);
            DOM.sinkEvents((Element)this.getElement(), (int)48);
        }

        public void onBrowserEvent(Event event) {
            Log.debug((String)"Event in AnnotationPopup");
            AnnotationPopupEventListener.this.onEvent(event);
        }

        public void show() {
            this.showing = true;
            super.show();
        }

        public void hide() {
            this.showing = false;
            super.hide();
        }

        public void hide(boolean autoClosed) {
            this.showing = false;
            super.hide(autoClosed);
        }

        public boolean isShown() {
            return this.showing;
        }
    }
}

