/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.seam;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.automation.core.util.DataModelProperties;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="damImportActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamImportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DamImportActions.class);
    protected static Random random = new Random();
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient WebActions webActions;
    protected DocumentModel importDocumentModel;
    protected Action selectedImportOption;
    protected List<Action> importOptions;
    protected String currentBatchId;

    public DocumentModel getImportDocumentModel() {
        if (this.importDocumentModel == null) {
            this.importDocumentModel = new SimpleDocumentModel();
        }
        return this.importDocumentModel;
    }

    public String getSelectedImportOptionId() {
        if (this.selectedImportOption == null) {
            this.selectedImportOption = this.importOptions != null && this.importOptions.size() > 0 ? this.importOptions.get(0) : null;
        }
        return this.selectedImportOption != null ? this.selectedImportOption.getId() : null;
    }

    public void setSelectedImportOptionId(String id) {
        for (Action importOption : this.importOptions) {
            if (!importOption.getId().equals(id)) continue;
            this.selectedImportOption = importOption;
            break;
        }
    }

    public Action getSelectedImportOption() {
        if (this.selectedImportOption == null) {
            this.selectedImportOption = this.importOptions != null && this.importOptions.size() > 0 ? this.importOptions.get(0) : null;
        }
        return this.selectedImportOption;
    }

    public List<Action> getImportOptions(String dropContext) {
        if (this.importOptions == null) {
            this.importOptions = new ArrayList<Action>();
            this.importOptions.addAll(this.webActions.getActionsList(dropContext));
        }
        return this.importOptions;
    }

    public String generateBatchId() {
        this.currentBatchId = "batch-" + new Date().getTime() + "-" + random.nextInt(1000);
        return this.currentBatchId;
    }

    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        return Integer.parseInt(t);
    }

    public String importAssets() throws ClientException {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        Map importOptionProperties = this.selectedImportOption.getProperties();
        String chainOrOperationId = null;
        chainOrOperationId = importOptionProperties.containsKey("chainId") ? "Chain." + (String)importOptionProperties.get("chainId") : (importOptionProperties.containsKey("operationId") ? (String)importOptionProperties.get("operationId") : this.selectedImportOption.getId());
        ArrayList<DataModel> dms = new ArrayList<DataModel>();
        for (String schema : this.importDocumentModel.getSchemas()) {
            dms.add(this.importDocumentModel.getDataModel(schema));
        }
        DataModelProperties properties = new DataModelProperties(dms);
        HashMap<String, DataModelProperties> contextParams = new HashMap<String, DataModelProperties>();
        contextParams.put("docMetaData", properties);
        bm.executeAndClean(this.currentBatchId, chainOrOperationId, this.documentManager, contextParams, null);
        return null;
    }

    public void cancel() {
        if (this.currentBatchId != null) {
            BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
            bm.clean(this.currentBatchId);
            this.importDocumentModel = null;
        }
    }
}

