/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.spec.GadgetSpec;

@Singleton
public class ContentRewriterFeatureFactory {
    private final GadgetSpecFactory specFactory;
    private final String includeUrls;
    private final String excludeUrls;
    private final String expires;
    private final Set<String> includeTags;
    private final boolean onlyAllowExcludes;
    private final ContentRewriterFeature defaultFeature;

    @Inject
    public ContentRewriterFeatureFactory(GadgetSpecFactory specFactory, @Named(value="shindig.content-rewrite.include-urls") String includeUrls, @Named(value="shindig.content-rewrite.exclude-urls") String excludeUrls, @Named(value="shindig.content-rewrite.expires") String expires, @Named(value="shindig.content-rewrite.include-tags") String includeTags, @Named(value="shindig.content-rewrite.only-allow-excludes") String onlyAllowExcludes) {
        this.specFactory = specFactory;
        this.includeUrls = includeUrls;
        this.excludeUrls = excludeUrls;
        this.expires = expires;
        this.onlyAllowExcludes = Boolean.parseBoolean(onlyAllowExcludes);
        ImmutableSet.Builder includeTagsBuilder = ImmutableSet.builder();
        for (String s : includeTags.trim().toLowerCase().split("\\s*,\\s*")) {
            if (s == null || s.length() <= 0) continue;
            includeTagsBuilder.add((Object)s);
        }
        this.includeTags = includeTagsBuilder.build();
        this.defaultFeature = new ContentRewriterFeature(null, includeUrls, excludeUrls, expires, this.includeTags, this.onlyAllowExcludes);
    }

    public ContentRewriterFeature getDefault() {
        return this.defaultFeature;
    }

    public ContentRewriterFeature get(HttpRequest request) {
        final Uri gadgetUri = request.getGadget();
        if (gadgetUri != null) {
            try {
                GadgetContext context = new GadgetContext(){

                    public Uri getUrl() {
                        return gadgetUri;
                    }
                };
                GadgetSpec spec = this.specFactory.getGadgetSpec(context);
                if (spec != null) {
                    return this.get(spec);
                }
            }
            catch (GadgetException ge) {
                return this.defaultFeature;
            }
        }
        return this.defaultFeature;
    }

    public ContentRewriterFeature get(GadgetSpec spec) {
        ContentRewriterFeature rewriterFeature = (ContentRewriterFeature)spec.getAttribute("content-rewriter");
        if (rewriterFeature != null) {
            return rewriterFeature;
        }
        rewriterFeature = new ContentRewriterFeature(spec, this.includeUrls, this.excludeUrls, this.expires, this.includeTags, this.onlyAllowExcludes);
        spec.setAttribute("content-rewriter", rewriterFeature);
        return rewriterFeature;
    }

    public ContentRewriterFeature createRewriteAllFeature(int ttl) {
        return new ContentRewriterFeature(null, ".*", "", ttl == -1 ? "HTTP" : Integer.toString(ttl), Collections.<String>emptySet(), false);
    }
}

