/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.virtualnavigation.service;

import java.util.List;
import org.nuxeo.ecm.virtualnavigation.action.NavTreeDescriptor;
import org.nuxeo.ecm.virtualnavigation.service.NavTreeRegistry;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class NavTreeService
extends DefaultComponent {
    public static String NAVTREE_EP = "navigationTree";
    protected NavTreeRegistry registry;

    public void activate(ComponentContext context) throws Exception {
        this.registry = new NavTreeRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.registry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (NAVTREE_EP.equals(extensionPoint)) {
            NavTreeDescriptor contrib = (NavTreeDescriptor)contribution;
            this.registry.addContribution(contrib);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (NAVTREE_EP.equals(extensionPoint)) {
            NavTreeDescriptor contrib = (NavTreeDescriptor)contribution;
            this.registry.removeContribution(contrib);
        }
    }

    public List<NavTreeDescriptor> getTreeDescriptors() {
        return this.registry.getTreeDescriptors(this.getDirectoryTreeService());
    }

    protected DirectoryTreeService getDirectoryTreeService() {
        DirectoryTreeService directoryTreeService = (DirectoryTreeService)Framework.getRuntime().getComponent(DirectoryTreeService.NAME);
        if (directoryTreeService == null) {
            return null;
        }
        return directoryTreeService;
    }

    public Long getLastModified() {
        Long res = super.getLastModified();
        DirectoryTreeService treeService = this.getDirectoryTreeService();
        if (treeService != null) {
            Long other = treeService.getLastModified();
            if (res == null || other != null && other.compareTo(res) > 0) {
                res = other;
            }
        }
        return res;
    }
}

