/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.formats.png.BitParser;
import org.apache.sanselan.formats.png.GammaCorrection;
import org.apache.sanselan.formats.png.ScanExpediter;
import org.apache.sanselan.formats.png.chunks.PNGChunkPLTE;
import org.apache.sanselan.formats.transparencyfilters.TransparencyFilter;

public class ScanExpediterInterlaced
extends ScanExpediter {
    public static final int[] Starting_Row = new int[]{0, 0, 4, 0, 2, 0, 1};
    public static final int[] Starting_Col = new int[]{0, 4, 0, 2, 0, 1, 0};
    public static final int[] Row_Increment = new int[]{8, 8, 8, 4, 4, 2, 2};
    public static final int[] Col_Increment = new int[]{8, 8, 4, 4, 2, 2, 1};
    public static final int[] Block_Height = new int[]{8, 8, 4, 4, 2, 2, 1};
    public static final int[] Block_Width = new int[]{8, 4, 4, 2, 2, 1, 1};

    public ScanExpediterInterlaced(int width, int height, InputStream is, BufferedImage bi, int color_type, int BitDepth, int bits_per_pixel, PNGChunkPLTE fPNGChunkPLTE, GammaCorrection fGammaCorrection, TransparencyFilter fTransparencyFilter) {
        super(width, height, is, bi, color_type, BitDepth, bits_per_pixel, fPNGChunkPLTE, fGammaCorrection, fTransparencyFilter);
    }

    private void visit(int x, int y, BufferedImage bi, BitParser fBitParser, int color_type, int pixel_index_in_scanline, PNGChunkPLTE fPNGChunkPLTE, GammaCorrection fGammaCorrection) throws ImageReadException, IOException {
        int rgb = this.getRGB(fBitParser, pixel_index_in_scanline);
        bi.setRGB(x, y, rgb);
    }

    public void drive() throws ImageReadException, IOException {
        for (int pass = 1; pass <= 7; ++pass) {
            boolean rows_in_pass;
            byte[] prev = null;
            int y = Starting_Row[pass - 1];
            boolean bl = rows_in_pass = y < this.height;
            while (y < this.height) {
                int x = Starting_Col[pass - 1];
                int pixel_index_in_scanline = 0;
                if (x < this.width) {
                    byte[] unfiltered;
                    int ColumnsInRow = 1 + (this.width - Starting_Col[pass - 1] - 1) / Col_Increment[pass - 1];
                    int bitsPerScanLine = this.bitsPerPixel * ColumnsInRow;
                    int pixel_bytes_per_scan_line = this.getBitsToBytesRoundingUp(bitsPerScanLine);
                    prev = unfiltered = this.getNextScanline(this.is, pixel_bytes_per_scan_line, prev, this.bytesPerPixel);
                    BitParser fBitParser = new BitParser(unfiltered, this.bitsPerPixel, this.bitDepth);
                    while (x < this.width) {
                        this.visit(x, y, this.bi, fBitParser, this.colorType, pixel_index_in_scanline, this.pngChunkPLTE, this.gammaCorrection);
                        x += Col_Increment[pass - 1];
                        ++pixel_index_in_scanline;
                    }
                }
                y += Row_Increment[pass - 1];
            }
        }
    }
}

