/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.jsecurity.authc.Account;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.MergableAuthenticationInfo;
import org.jsecurity.authc.SimpleAuthenticationInfo;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.SimpleAuthorizationInfo;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.subject.SimplePrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAccount
implements Account,
MergableAuthenticationInfo,
Serializable {
    private SimpleAuthenticationInfo authcInfo;
    private SimpleAuthorizationInfo authzInfo;
    private boolean locked;
    private boolean credentialsExpired;

    public SimpleAccount() {
    }

    public SimpleAccount(Object principal, Object credentials, String realmName) {
        this(principal instanceof PrincipalCollection ? (PrincipalCollection)principal : new SimplePrincipalCollection(principal, realmName), credentials);
    }

    public SimpleAccount(Collection principals, Object credentials, String realmName) {
        this(new SimplePrincipalCollection(principals, realmName), credentials);
    }

    public SimpleAccount(PrincipalCollection principals, Object credentials) {
        this.authcInfo = new SimpleAuthenticationInfo(principals, credentials);
        this.authzInfo = new SimpleAuthorizationInfo();
    }

    public SimpleAccount(PrincipalCollection principals, Object credentials, Set<String> roles) {
        this.authcInfo = new SimpleAuthenticationInfo(principals, credentials);
        this.authzInfo = new SimpleAuthorizationInfo(roles);
    }

    public SimpleAccount(Object principal, Object credentials, String realmName, Set<String> roleNames, Set<Permission> permissions) {
        this.authcInfo = new SimpleAuthenticationInfo(new SimplePrincipalCollection(principal, realmName), credentials);
        this.authzInfo = new SimpleAuthorizationInfo(roleNames);
        this.authzInfo.setObjectPermissions(permissions);
    }

    public SimpleAccount(Collection principals, Object credentials, String realmName, Set<String> roleNames, Set<Permission> permissions) {
        this.authcInfo = new SimpleAuthenticationInfo(new SimplePrincipalCollection(principals, realmName), credentials);
        this.authzInfo = new SimpleAuthorizationInfo(roleNames);
        this.authzInfo.setObjectPermissions(permissions);
    }

    public SimpleAccount(PrincipalCollection principals, Object credentials, Set<String> roleNames, Set<Permission> permissions) {
        this.authcInfo = new SimpleAuthenticationInfo(principals, credentials);
        this.authzInfo = new SimpleAuthorizationInfo(roleNames);
        this.authzInfo.setObjectPermissions(permissions);
    }

    @Override
    public PrincipalCollection getPrincipals() {
        return this.authcInfo.getPrincipals();
    }

    public void setPrincipals(PrincipalCollection principals) {
        this.authcInfo.setPrincipals(principals);
    }

    @Override
    public Object getCredentials() {
        return this.authcInfo.getCredentials();
    }

    public void setCredentials(Object credentials) {
        this.authcInfo.setCredentials(credentials);
    }

    @Override
    public Collection<String> getRoles() {
        return this.authzInfo.getRoles();
    }

    public void setRoles(Set<String> roles) {
        this.authzInfo.setRoles(roles);
    }

    public void addRole(String role) {
        this.authzInfo.addRole(role);
    }

    public void addRole(Collection<String> roles) {
        this.authzInfo.addRoles(roles);
    }

    @Override
    public Collection<String> getStringPermissions() {
        return this.authzInfo.getStringPermissions();
    }

    public void setStringPermissions(Set<String> permissions) {
        this.authzInfo.setStringPermissions(permissions);
    }

    public void addStringPermission(String permission) {
        this.authzInfo.addStringPermission(permission);
    }

    public void addStringPermissions(Collection<String> permissions) {
        this.authzInfo.addStringPermissions(permissions);
    }

    @Override
    public Collection<Permission> getObjectPermissions() {
        return this.authzInfo.getObjectPermissions();
    }

    public void setObjectPermissions(Set<Permission> permissions) {
        this.authzInfo.setObjectPermissions(permissions);
    }

    public void addObjectPermission(Permission permission) {
        this.authzInfo.addObjectPermission(permission);
    }

    public void addObjectPermissions(Collection<Permission> permissions) {
        this.authzInfo.addObjectPermissions(permissions);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isCredentialsExpired() {
        return this.credentialsExpired;
    }

    public void setCredentialsExpired(boolean credentialsExpired) {
        this.credentialsExpired = credentialsExpired;
    }

    @Override
    public void merge(AuthenticationInfo info) {
        this.authcInfo.merge(info);
        if (info instanceof SimpleAccount) {
            SimpleAccount otherAccount = (SimpleAccount)info;
            if (otherAccount.isLocked()) {
                this.setLocked(true);
            }
            if (otherAccount.isCredentialsExpired()) {
                this.setCredentialsExpired(true);
            }
        }
    }

    public int hashCode() {
        return this.getPrincipals() != null ? this.getPrincipals().hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SimpleAccount) {
            SimpleAccount sa = (SimpleAccount)o;
            return this.getPrincipals() != null ? this.getPrincipals().equals(sa.getPrincipals()) : sa.getPrincipals() == null;
        }
        return false;
    }

    public String toString() {
        return this.getPrincipals() != null ? this.getPrincipals().toString() : "empty";
    }
}

