/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.realm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.credential.CredentialsMatcher;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.AuthorizationInfo;
import org.jsecurity.authz.AuthorizingAccount;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.UnauthorizedException;
import org.jsecurity.authz.permission.PermissionResolver;
import org.jsecurity.authz.permission.PermissionResolverAware;
import org.jsecurity.authz.permission.WildcardPermissionResolver;
import org.jsecurity.cache.Cache;
import org.jsecurity.cache.CacheManager;
import org.jsecurity.realm.AuthenticatingRealm;
import org.jsecurity.subject.PrincipalCollection;
import org.jsecurity.util.Initializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizingRealm
extends AuthenticatingRealm
implements Initializable,
PermissionResolverAware {
    private static final Log log = LogFactory.getLog(AuthorizingRealm.class);
    private static final String DEFAULT_AUTHORIZATION_CACHE_POSTFIX = "-authorization";
    private static int INSTANCE_COUNT = 0;
    private Cache authorizationCache = null;
    private String authorizationCacheName = null;
    private PermissionResolver permissionResolver = new WildcardPermissionResolver();

    public AuthorizingRealm() {
    }

    public AuthorizingRealm(CacheManager cacheManager) {
        super(cacheManager);
    }

    public AuthorizingRealm(CredentialsMatcher matcher) {
        super(matcher);
    }

    public AuthorizingRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        super(cacheManager, matcher);
    }

    public void setAuthorizationCache(Cache authorizationCache) {
        this.authorizationCache = authorizationCache;
        if (this.authorizationCache != null) {
            this.afterAuthorizationCacheSet();
        }
    }

    public Cache getAuthorizationCache() {
        return this.authorizationCache;
    }

    public String getAuthorizationCacheName() {
        return this.authorizationCacheName;
    }

    public void setAuthorizationCacheName(String authorizationCacheName) {
        this.authorizationCacheName = authorizationCacheName;
    }

    public PermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    @Override
    public void setPermissionResolver(PermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    @Override
    public final void init() {
        this.initAuthorizationCache();
    }

    @Override
    protected void afterCacheManagerSet() {
        this.authorizationCache = null;
        this.initAuthorizationCache();
    }

    protected void afterAuthorizationCacheSet() {
    }

    public void initAuthorizationCache() {
        Cache cache;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing authorization cache.");
        }
        if ((cache = this.getAuthorizationCache()) == null) {
            CacheManager cacheManager;
            if (log.isDebugEnabled()) {
                log.debug((Object)"No cache implementation set.  Checking cacheManager...");
            }
            if ((cacheManager = this.getCacheManager()) != null) {
                String cacheName = this.getAuthorizationCacheName();
                if (cacheName == null) {
                    cacheName = this.getClass().getName() + "-" + INSTANCE_COUNT++ + DEFAULT_AUTHORIZATION_CACHE_POSTFIX;
                    this.setAuthorizationCacheName(cacheName);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CacheManager [" + cacheManager + "] has been configured.  Building " + "authorization cache named [" + cacheName + "]"));
                }
                cache = cacheManager.getCache(cacheName);
                this.setAuthorizationCache(cache);
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No cache or cacheManager properties have been set.  Authorization caching is disabled.");
            }
        }
    }

    public AuthorizationInfo getAuthorizationInfo(PrincipalCollection principals) {
        Object key;
        Cache authzCache;
        if (principals == null) {
            return null;
        }
        AuthorizationInfo info = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Retrieving AuthorizationInfo for principals [" + principals + "]"));
        }
        if ((authzCache = this.getAuthorizationCache()) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Attempting to retrieve the AuthorizationIfno from cache.");
            }
            key = this.getAuthorizationCacheKey(principals);
            info = (AuthorizationInfo)authzCache.get(key);
            if (log.isTraceEnabled()) {
                if (info == null) {
                    log.trace((Object)("No AuthorizationInfo found in cache for principals [" + principals + "]"));
                } else {
                    log.trace((Object)("AuthorizationInfo found in cache for principals [" + principals + "]"));
                }
            }
        }
        if (info == null && (info = this.doGetAuthorizationInfo(principals)) != null && authzCache != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Caching authorization info for principals: [" + principals + "]."));
            }
            key = this.getAuthorizationCacheKey(principals);
            authzCache.put(key, info);
        }
        return info;
    }

    protected Object getAuthorizationCacheKey(PrincipalCollection principals) {
        return principals;
    }

    protected void clearCachedAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            return;
        }
        Cache cache = this.getAuthorizationCache();
        if (cache != null) {
            Object key = this.getAuthorizationCacheKey(principals);
            cache.remove(key);
        }
    }

    protected abstract AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection var1);

    private Collection<Permission> getPermissions(AuthorizationInfo info) {
        HashSet<Permission> permissions = new HashSet<Permission>();
        if (info != null) {
            if (info.getObjectPermissions() != null) {
                permissions.addAll(info.getObjectPermissions());
            }
            if (info.getStringPermissions() != null) {
                for (String strPermission : info.getStringPermissions()) {
                    Permission permission = this.getPermissionResolver().resolvePermission(strPermission);
                    permissions.add(permission);
                }
            }
        }
        if (permissions.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(permissions);
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, String permission) {
        Permission p = this.getPermissionResolver().resolvePermission(permission);
        return this.isPermitted(principals, p);
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        AuthorizationInfo info = this.getAuthorizationInfo(principals);
        return this.isPermitted(permission, info);
    }

    private boolean isPermitted(Permission permission, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            return ((AuthorizingAccount)info).isPermitted(permission);
        }
        Collection<Permission> perms = this.getPermissions(info);
        if (perms != null && !perms.isEmpty()) {
            for (Permission perm : perms) {
                if (!perm.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection subjectIdentifier, String ... permissions) {
        ArrayList<Permission> perms = new ArrayList<Permission>(permissions.length);
        for (String permString : permissions) {
            perms.add(this.getPermissionResolver().resolvePermission(permString));
        }
        return this.isPermitted(subjectIdentifier, perms);
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, List<Permission> permissions) {
        AuthorizationInfo info = this.getAuthorizationInfo(principals);
        return this.isPermitted(permissions, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        boolean[] result;
        if (info instanceof AuthorizingAccount) {
            return ((AuthorizingAccount)info).isPermitted(permissions);
        }
        if (permissions != null && !permissions.isEmpty()) {
            int size = permissions.size();
            result = new boolean[size];
            int i = 0;
            for (Permission p : permissions) {
                result[i++] = this.isPermitted(p, info);
            }
        } else {
            result = new boolean[]{};
        }
        return result;
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection subjectIdentifier, String ... permissions) {
        if (permissions != null && permissions.length > 0) {
            ArrayList<Permission> perms = new ArrayList<Permission>(permissions.length);
            for (String permString : permissions) {
                perms.add(this.getPermissionResolver().resolvePermission(permString));
            }
            return this.isPermittedAll(subjectIdentifier, perms);
        }
        return false;
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principal, Collection<Permission> permissions) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        return info != null && this.isPermittedAll(permissions, info);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            return ((AuthorizingAccount)info).isPermittedAll(permissions);
        }
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission p : permissions) {
                if (this.isPermitted(p, info)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void checkPermission(PrincipalCollection subjectIdentifier, String permission) throws AuthorizationException {
        Permission p = this.getPermissionResolver().resolvePermission(permission);
        this.checkPermission(subjectIdentifier, p);
    }

    @Override
    public void checkPermission(PrincipalCollection principal, Permission permission) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkPermission(permission, info);
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            ((AuthorizingAccount)info).checkPermission(permission);
        } else if (!this.isPermitted(permission, info)) {
            String msg = "User is not permitted [" + permission + "]";
            throw new UnauthorizedException(msg);
        }
    }

    @Override
    public void checkPermissions(PrincipalCollection subjectIdentifier, String ... permissions) throws AuthorizationException {
        if (permissions != null) {
            for (String permString : permissions) {
                this.checkPermission(subjectIdentifier, permString);
            }
        }
    }

    @Override
    public void checkPermissions(PrincipalCollection principal, Collection<Permission> permissions) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkPermissions(permissions, info);
    }

    protected void checkPermissions(Collection<Permission> permissions, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            ((AuthorizingAccount)info).checkPermissions(permissions);
        } else if (permissions != null && !permissions.isEmpty()) {
            for (Permission p : permissions) {
                this.checkPermission(p, info);
            }
        }
    }

    @Override
    public boolean hasRole(PrincipalCollection principal, String roleIdentifier) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        return this.hasRole(roleIdentifier, info);
    }

    protected boolean hasRole(String roleIdentifier, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            return ((AuthorizingAccount)info).hasRole(roleIdentifier);
        }
        return info != null && info.getRoles() != null && info.getRoles().contains(roleIdentifier);
    }

    @Override
    public boolean[] hasRoles(PrincipalCollection principal, List<String> roleIdentifiers) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        boolean[] result = new boolean[roleIdentifiers != null ? roleIdentifiers.size() : 0];
        if (info != null) {
            result = this.hasRoles(roleIdentifiers, info);
        }
        return result;
    }

    protected boolean[] hasRoles(List<String> roleIdentifiers, AuthorizationInfo info) {
        boolean[] result;
        if (info instanceof AuthorizingAccount) {
            return ((AuthorizingAccount)info).hasRoles(roleIdentifiers);
        }
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            int size = roleIdentifiers.size();
            result = new boolean[size];
            int i = 0;
            for (String roleName : roleIdentifiers) {
                result[i++] = this.hasRole(roleName, info);
            }
        } else {
            result = new boolean[]{};
        }
        return result;
    }

    @Override
    public boolean hasAllRoles(PrincipalCollection principal, Collection<String> roleIdentifiers) {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        return info != null && this.hasAllRoles(roleIdentifiers, info);
    }

    private boolean hasAllRoles(Collection<String> roleIdentifiers, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            return ((AuthorizingAccount)info).hasAllRoles(roleIdentifiers);
        }
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            for (String roleName : roleIdentifiers) {
                if (this.hasRole(roleName, info)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void checkRole(PrincipalCollection principal, String role) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkRole(role, info);
    }

    protected void checkRole(String role, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            ((AuthorizingAccount)info).checkRole(role);
        } else if (!this.hasRole(role, info)) {
            String msg = "User does not have role [" + role + "]";
            throw new UnauthorizedException(msg);
        }
    }

    @Override
    public void checkRoles(PrincipalCollection principal, Collection<String> roles) throws AuthorizationException {
        AuthorizationInfo info = this.getAuthorizationInfo(principal);
        this.checkRoles(roles, info);
    }

    protected void checkRoles(Collection<String> roles, AuthorizationInfo info) {
        if (info instanceof AuthorizingAccount) {
            ((AuthorizingAccount)info).checkRoles(roles);
        } else if (roles != null && !roles.isEmpty()) {
            for (String roleName : roles) {
                this.checkRole(roleName, info);
            }
        }
    }

    @Override
    public void onLogout(PrincipalCollection principals) {
        this.clearCachedAuthorizationInfo(principals);
    }
}

