/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt.eis;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.cache.HashtableCacheManager;
import org.jsecurity.session.Session;
import org.jsecurity.session.mgt.SimpleSession;
import org.jsecurity.session.mgt.eis.CachingSessionDAO;
import org.jsecurity.util.JavaEnvironment;

public class MemorySessionDAO
extends CachingSessionDAO {
    private static final Log log = LogFactory.getLog(MemorySessionDAO.class);
    private static final String RANDOM_NUM_GENERATOR_ALGORITHM_NAME = "SHA1PRNG";
    private Random randomNumberGenerator = null;

    public MemorySessionDAO() {
        this.setCacheManager(new HashtableCacheManager());
    }

    private Random getRandomNumberGenerator() {
        if (this.randomNumberGenerator == null) {
            if (log.isInfoEnabled()) {
                String msg = "On Java 1.4 platforms and below, there is no built-in UUID class (Java 1.5 and above only) to use for Session ID generation - reverting to SecureRandom number generator.  Although this is probably sufficient for all but high user volume applications, if you see ID collision, you will want to upgrade to JDK 1.5 or better as soon as possible, or subclass the " + this.getClass().getName() + " class and override the #generateNewSessionId() " + "method to use a better algorithm.";
                log.info((Object)msg);
            }
            try {
                this.randomNumberGenerator = SecureRandom.getInstance(RANDOM_NUM_GENERATOR_ALGORITHM_NAME);
            }
            catch (NoSuchAlgorithmException e) {
                this.randomNumberGenerator = new SecureRandom();
            }
        }
        return this.randomNumberGenerator;
    }

    protected Serializable generateNewSessionId() {
        if (JavaEnvironment.isAtLeastVersion15()) {
            return UUID.randomUUID().toString();
        }
        return Long.toString(this.getRandomNumberGenerator().nextLong());
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateNewSessionId();
        this.assignSessionId(session, sessionId);
        return sessionId;
    }

    protected void assignSessionId(Session session, Serializable sessionId) {
        ((SimpleSession)session).setId(sessionId);
    }

    protected Session doReadSession(Serializable sessionId) {
        return null;
    }

    protected void doUpdate(Session session) {
    }

    protected void doDelete(Session session) {
    }
}

