/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.util.AntPathMatcher;
import org.jsecurity.util.PatternMatcher;
import org.jsecurity.util.StringUtils;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.filter.PathConfigProcessor;
import org.jsecurity.web.servlet.AdviceFilter;

public abstract class PathMatchingFilter
extends AdviceFilter
implements PathConfigProcessor {
    private static final Log log = LogFactory.getLog(PathMatchingFilter.class);
    protected PatternMatcher pathMatcher = new AntPathMatcher();
    protected Map<String, Object> appliedPaths = new LinkedHashMap<String, Object>();

    public void processPathConfig(String path, String config) {
        String[] values = null;
        if (config != null) {
            values = StringUtils.split(config);
        }
        this.appliedPaths.put(path, values);
    }

    protected String getPathWithinApplication(ServletRequest request) {
        return WebUtils.getPathWithinApplication(WebUtils.toHttp(request));
    }

    protected boolean pathsMatch(String path, ServletRequest request) {
        String requestURI = this.getPathWithinApplication(request);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to match pattern [" + path + "] with current requestURI [" + requestURI + "]..."));
        }
        return this.pathsMatch(path, requestURI);
    }

    protected boolean pathsMatch(String pattern, String path) {
        return this.pathMatcher.matches(pattern, path);
    }

    public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        if (this.appliedPaths == null || this.appliedPaths.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"appliedPaths property is null or empty.  This Filter will passthrough immediately.");
            }
            return true;
        }
        for (String path : this.appliedPaths.keySet()) {
            if (!this.pathsMatch(path, request)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current requestURI matches pattern [" + path + "].  Performing onPreHandle check..."));
            }
            Object config = this.appliedPaths.get(path);
            return this.onPreHandle(request, response, config);
        }
        return true;
    }

    protected boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return true;
    }
}

