/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc.credential;

import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.credential.SimpleCredentialsMatcher;
import org.jsecurity.codec.Base64;
import org.jsecurity.codec.Hex;
import org.jsecurity.crypto.hash.AbstractHash;
import org.jsecurity.crypto.hash.Hash;

public abstract class HashedCredentialsMatcher
extends SimpleCredentialsMatcher {
    private boolean storedCredentialsHexEncoded = true;
    private boolean hashSalted = false;
    private int hashIterations = 1;

    public boolean isStoredCredentialsHexEncoded() {
        return this.storedCredentialsHexEncoded;
    }

    public void setStoredCredentialsHexEncoded(boolean storedCredentialsHexEncoded) {
        this.storedCredentialsHexEncoded = storedCredentialsHexEncoded;
    }

    public boolean isHashSalted() {
        return this.hashSalted;
    }

    public void setHashSalted(boolean hashSalted) {
        this.hashSalted = hashSalted;
    }

    public int getHashIterations() {
        return this.hashIterations;
    }

    public void setHashIterations(int hashIterations) {
        this.hashIterations = hashIterations < 1 ? 1 : hashIterations;
    }

    protected Object getSalt(AuthenticationToken token) {
        return token.getPrincipal();
    }

    protected Object getCredentials(AuthenticationToken token) {
        Object credentials = token.getCredentials();
        Object salt = this.isHashSalted() ? this.getSalt(token) : null;
        return this.hashProvidedCredentials(credentials, salt, this.getHashIterations());
    }

    protected Object getCredentials(AuthenticationInfo info) {
        Object credentials = info.getCredentials();
        byte[] storedBytes = this.toBytes(credentials);
        if (credentials instanceof String || credentials instanceof char[]) {
            storedBytes = this.isStoredCredentialsHexEncoded() ? Hex.decode(storedBytes) : Base64.decode(storedBytes);
        }
        AbstractHash hash = this.newHashInstance();
        hash.setBytes(storedBytes);
        return hash;
    }

    protected abstract Hash hashProvidedCredentials(Object var1, Object var2, int var3);

    protected abstract AbstractHash newHashInstance();
}

