/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.LexicalScope;
import com.google.caja.ancillary.linter.ScopeAnalyzer;
import com.google.caja.ancillary.linter.SymbolTable;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Reference;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LiveSet {
    static final LiveSet EMPTY = new LiveSet(Collections.<Pair<String, LexicalScope>>emptySet());
    final Set<Pair<String, LexicalScope>> symbols;

    LiveSet(ParseTreeNode scopeRoot) {
        Set<Pair<String, LexicalScope>> symbols = Sets.newLinkedHashSet();
        LexicalScope scope = ScopeAnalyzer.containingScopeForNode(scopeRoot);
        block0: for (String symbolName : scope.symbols.symbolNames()) {
            SymbolTable.Symbol s = scope.symbols.getSymbol(symbolName);
            for (AncestorChain<?> decl : s.getDeclarations()) {
                if (decl.node != scopeRoot) continue;
                symbols.add(Pair.pair(symbolName, scope));
                continue block0;
            }
        }
        this.symbols = Collections.unmodifiableSet(symbols);
    }

    private LiveSet(Set<Pair<String, LexicalScope>> symbols) {
        this.symbols = Collections.unmodifiableSet(symbols);
    }

    LiveSet union(LiveSet other) {
        Set<Pair<String, LexicalScope>> usymbols = Sets.newLinkedHashSet(this.symbols);
        usymbols.addAll(other.symbols);
        return new LiveSet(usymbols);
    }

    LiveSet intersection(LiveSet other) {
        Set<Pair<String, LexicalScope>> isymbols = Sets.newLinkedHashSet(this.symbols);
        isymbols.retainAll(other.symbols);
        return isymbols.isEmpty() ? EMPTY : new LiveSet(isymbols);
    }

    LiveSet with(Declaration d) {
        return this.with(d.getIdentifierName(), ScopeAnalyzer.definingScopeForNode(d));
    }

    LiveSet with(Reference r) {
        String name = r.getIdentifierName();
        LexicalScope scope = ScopeAnalyzer.containingScopeForNode(r);
        while (scope != null) {
            if (scope.symbols.getSymbol(name) != null) {
                return this.with(name, scope);
            }
            scope = scope.parent;
        }
        return this;
    }

    private LiveSet with(String name, LexicalScope scope) {
        Pair<String, LexicalScope> p = Pair.pair(name, scope);
        if (this.symbols.contains(p)) {
            return this;
        }
        Set<Pair<String, LexicalScope>> wsymbols = Sets.newLinkedHashSet(this.symbols);
        wsymbols.add(p);
        return new LiveSet(wsymbols);
    }

    LiveSet filter(LexicalScope containingScope) {
        Iterator<Pair<String, LexicalScope>> it = this.symbols.iterator();
        while (it.hasNext()) {
            Pair<String, LexicalScope> s = it.next();
            if (LiveSet.isAncestorOf((LexicalScope)s.b, containingScope)) continue;
            Set<Pair<String, LexicalScope>> filtered = Sets.newLinkedHashSet(this.symbols);
            filtered.remove(s);
            while (it.hasNext()) {
                s = it.next();
                if (LiveSet.isAncestorOf((LexicalScope)s.b, containingScope)) continue;
                filtered.remove(s);
            }
            return filtered.isEmpty() ? EMPTY : new LiveSet(filtered);
        }
        return this;
    }

    private static final boolean isAncestorOf(LexicalScope a, LexicalScope b) {
        return a == b || a.root.depth < b.root.depth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        String sep = "";
        for (Pair<String, LexicalScope> s : this.symbols) {
            int depth;
            int n = depth = s.b != null ? ((LexicalScope)s.b).root.depth : -1;
            if (ScopeAnalyzer.ECMASCRIPT_BUILTINS.contains(s.a) && depth == 0) continue;
            sb.append(sep).append((String)s.a).append('@').append(depth);
            sep = " ";
        }
        return sb.append(')').toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LiveSet)) {
            return false;
        }
        return ((Object)this.symbols).equals(((LiveSet)o).symbols);
    }

    public int hashCode() {
        return ((Object)this.symbols).hashCode();
    }
}

