/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.ContentType;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class UriFetcher {
    private static final Pattern CHARSET = Pattern.compile(";\\s*charset\\s*=([^;]*)", 2);

    UriFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Content fetch(URI uri) throws IOException {
        String scheme = uri.getScheme();
        if (!Strings.equalsIgnoreCase("http", scheme) && !Strings.equalsIgnoreCase("https", scheme)) {
            throw new IOException("Bad scheme: " + uri);
        }
        URLConnection conn = uri.toURL().openConnection();
        conn.connect();
        StringBuilder text = new StringBuilder();
        InputStream in = conn.getInputStream();
        try {
            int n;
            String charset = UriFetcher.charsetFromContentType(conn.getContentType());
            if (charset == null) {
                charset = "UTF-8";
            }
            InputStreamReader r = new InputStreamReader(in, charset);
            char[] buf = new char[4096];
            while ((n = r.read(buf)) > 0) {
                text.append(buf, 0, n);
            }
        }
        finally {
            in.close();
        }
        ContentType t = ContentType.guess(conn.getContentType(), uri.getPath(), text);
        return new Content(text.toString(), t);
    }

    private static String charsetFromContentType(String contentTypeHeader) {
        Matcher m = CHARSET.matcher(contentTypeHeader);
        if (!m.find()) {
            return null;
        }
        String mimeTypePart = m.group(1);
        String charset = mimeTypePart.replaceAll("[\\s\"']+", "");
        return "".equals(charset) ? null : charset;
    }
}

