/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleDescription;
import com.google.caja.parser.quasiliteral.RulesetDescription;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessageQueue;
import java.util.ArrayList;
import java.util.Map;

@RulesetDescription(name="Innocent Code Transformer", synopsis="Lets trusted JS code interact with cajoled code")
public class InnocentCodeRewriter
extends Rewriter {
    public final Rule[] innocentRules = new Rule[]{new Rule(){

        @RuleDescription(name="module", synopsis="", reason="", matches="{@ss*;}", substitutes="@startStmts*;@thisVar?;@expanded*;")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (node instanceof Block && scope == null) {
                Scope s2 = Scope.fromProgram((Block)node, InnocentCodeRewriter.this.mq);
                ArrayList<ParseTreeNode> expanded = new ArrayList<ParseTreeNode>();
                for (ParseTreeNode parseTreeNode : node.children()) {
                    expanded.add(InnocentCodeRewriter.this.expand(parseTreeNode, s2));
                }
                ParseTreeNode thisVar = null;
                if (s2.hasFreeThis()) {
                    thisVar = QuasiBuilder.substV("var this___ = this;", new Object[0]);
                }
                return this.substV("startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "thisVar", thisVar, "expanded", new ParseTreeNodeContainer(expanded));
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="functions", synopsis="", reason="", matches="function @f?(@ps*) { @bs* }", substitutes="function @f?(@params*) {  @startStmts*;  @thisVar?;  @body*}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = this.match(node);
            if (bindings != null) {
                Scope s2 = Scope.fromFunctionConstructor(scope, (FunctionConstructor)node);
                ParseTreeNode params = this.expandAll(bindings.get("ps"), s2);
                ParseTreeNode body = this.expandAll(bindings.get("bs"), s2);
                ParseTreeNode thisVar = null;
                if (s2.hasFreeThis()) {
                    thisVar = QuasiBuilder.substV("var this___ = this && this.___ ? void 0 : this;", new Object[0]);
                }
                return this.substV("thisVar", thisVar, "f", bindings.get("f"), "params", params, "startStmts", new ParseTreeNodeContainer(s2.getStartStatements()), "body", body);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="this", synopsis="Replaces references to 'this' with references to this___", reason="So that we can check whether this points to the global scope and substitute a reasonable value.", matches="this", substitutes="this___")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            if (this.match(node) != null) {
                return this.substV(new Object[0]);
            }
            return NONE;
        }
    }, new Rule(){

        @RuleDescription(name="foreach", synopsis="", reason="Filters out hidden properties ending in ___ in for loops", matches="for (@k in @o) @ss;", substitutes="for (@kTempStmt in @o) {   if (@kTempRef.match(/___$/)) {     continue;   }   @kAssignment;  @ss;}")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            Map<String, ParseTreeNode> bindings = 4.makeBindings();
            if (QuasiBuilder.match("for (var @k in @o) @ss;", node, bindings)) {
                bindings.put("k", new Reference((Identifier)bindings.get("k")));
            } else if (QuasiBuilder.match("for (@k in @o) @ss;", node, bindings)) {
                ExpressionStmt es = (ExpressionStmt)bindings.get("k");
                bindings.put("k", es.getExpression());
            } else {
                return NONE;
            }
            Identifier kTemp = scope.declareStartOfScopeTempVariable();
            ParseTreeNode kAssignment = QuasiBuilder.substV("@k = @kTempRef;", "k", bindings.get("k"), "kTempRef", new Reference(kTemp));
            kAssignment = this.expandAll(kAssignment, scope);
            kAssignment = 4.newExprStmt((Expression)kAssignment);
            return this.substV("kTempStmt", 4.newExprStmt(new Reference(kTemp)), "kTempRef", new Reference(kTemp), "o", bindings.get("o"), "kAssignment", kAssignment, "ss", this.expandAll(bindings.get("ss"), scope));
        }
    }, new Rule(){

        @RuleDescription(name="recurse", synopsis="Automatically recurse into some structures", reason="")
        public ParseTreeNode fire(ParseTreeNode node, Scope scope) {
            return this.expandAll(node, scope);
        }
    }};

    public InnocentCodeRewriter(MessageQueue mq, boolean logging) {
        super(mq, false, logging);
        this.addRules(this.innocentRules);
    }
}

