/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.MessageContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DebuggingSymbols {
    private Map<FilePosition, Integer> positions = new LinkedHashMap<FilePosition, Integer>();

    DebuggingSymbols() {
    }

    public int indexForPosition(FilePosition pos) {
        Integer index = this.positions.get(pos);
        if (index == null) {
            index = this.positions.size();
            this.positions.put(pos, index);
        }
        return index;
    }

    public ParseTreeNodeContainer toJavascriptSideTable() {
        MessageContext mc = new MessageContext();
        for (InputSource is : this.allInputSources()) {
            mc.addInputSource(is);
        }
        ArrayList<Literal> debugTable = new ArrayList<Literal>(this.positions.size() * 2 - 1);
        String last = null;
        for (FilePosition p : this.positions.keySet()) {
            String posStr = DebuggingSymbols.formatPos(p, mc);
            int prefixLen = 0;
            if (last != null) {
                prefixLen = DebuggingSymbols.commonPrefixLength(posStr, last);
                debugTable.add(new IntegerLiteral(FilePosition.UNKNOWN, prefixLen));
            }
            debugTable.add(StringLiteral.valueOf(FilePosition.UNKNOWN, posStr.substring(prefixLen)));
            last = posStr;
        }
        return new ParseTreeNodeContainer(debugTable);
    }

    public boolean isEmpty() {
        return this.positions.isEmpty();
    }

    private Set<InputSource> allInputSources() {
        HashSet<InputSource> sources = new HashSet<InputSource>();
        for (FilePosition p : this.positions.keySet()) {
            sources.add(p.source());
        }
        return sources;
    }

    private static int commonPrefixLength(String a, String b) {
        int prefixLen;
        int n = Math.min(a.length(), b.length());
        for (prefixLen = 0; prefixLen < n && a.charAt(prefixLen) == b.charAt(prefixLen); ++prefixLen) {
        }
        return prefixLen;
    }

    private static String formatPos(FilePosition pos, MessageContext mc) {
        StringBuilder sb = new StringBuilder();
        try {
            pos.format(mc, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return sb.toString();
    }
}

