/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TypedUpdater
implements Updater {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$expression$TypedUpdater == null ? (class$org$apache$commons$betwixt$expression$TypedUpdater = TypedUpdater.class$("org.apache.commons.betwixt.expression.TypedUpdater")) : class$org$apache$commons$betwixt$expression$TypedUpdater));
    private Class valueType;
    static /* synthetic */ Class class$org$apache$commons$betwixt$expression$TypedUpdater;

    public void update(Context context, Object newValue) {
        Object bean = context.getBean();
        if (bean != null) {
            if (newValue instanceof String) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Converting primitive to " + this.valueType));
                }
                newValue = context.getObjectStringConverter().stringToObject((String)newValue, this.valueType, context);
            }
            if (newValue != null) {
                // empty if block
            }
            if (newValue instanceof Collection && this.valueType.isArray()) {
                Collection valuesAsCollection = (Collection)newValue;
                Class<?> componentType = this.valueType.getComponentType();
                if (componentType != null) {
                    Object[] valuesAsArray = (Object[])Array.newInstance(componentType, valuesAsCollection.size());
                    newValue = valuesAsCollection.toArray(valuesAsArray);
                }
            }
            try {
                this.executeUpdate(context, bean, newValue);
            }
            catch (Exception e) {
                String valueTypeName = newValue != null ? newValue.getClass().getName() : "null";
                log.warn((Object)("Cannot evaluate: " + this.toString() + " on bean: " + bean + " of type: " + bean.getClass().getName() + " with value: " + newValue + " of type: " + valueTypeName));
                this.handleException(context, e);
            }
        }
    }

    public Class getValueType() {
        return this.valueType;
    }

    public void setValueType(Class valueType) {
        this.valueType = valueType;
    }

    protected abstract void executeUpdate(Context var1, Object var2, Object var3) throws Exception;

    protected void handleException(Context context, Exception e) {
        log.info((Object)("Caught exception: " + e), (Throwable)e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

