/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.schema;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.schema.Attribute;
import org.apache.commons.betwixt.schema.ComplexLocalElement;
import org.apache.commons.betwixt.schema.ElementReference;
import org.apache.commons.betwixt.schema.LocalElement;
import org.apache.commons.betwixt.schema.Schema;
import org.apache.commons.betwixt.schema.SimpleLocalElement;
import org.apache.commons.betwixt.schema.TranscriptionConfiguration;

public abstract class ComplexType {
    protected List elements = new ArrayList();
    protected List attributes = new ArrayList();

    public ComplexType() {
    }

    public ComplexType(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        elementDescriptor = this.fillDescriptor(elementDescriptor, schema);
        this.init(configuration, elementDescriptor, schema);
    }

    protected ElementDescriptor fillDescriptor(ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        if (elementDescriptor.isHollow()) {
            Class type = elementDescriptor.getSingularPropertyType();
            if (type == null) {
                type = elementDescriptor.getPropertyType();
            }
            if (type != null) {
                XMLBeanInfo filledBeanInfo = schema.introspect(type);
                elementDescriptor = filledBeanInfo.getElementDescriptor();
            }
        }
        return elementDescriptor;
    }

    protected void init(TranscriptionConfiguration configuration, ElementDescriptor elementDescriptor, Schema schema) throws IntrospectionException {
        AttributeDescriptor[] attributeDescriptors = elementDescriptor.getAttributeDescriptors();
        int length = attributeDescriptors.length;
        for (int i = 0; i < length; ++i) {
            String uri = attributeDescriptors[i].getURI();
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri)) continue;
            this.attributes.add(new Attribute(attributeDescriptors[i]));
        }
        ElementDescriptor[] elementDescriptors = elementDescriptor.getElementDescriptors();
        int length2 = elementDescriptors.length;
        for (int i = 0; i < length2; ++i) {
            if (elementDescriptors[i].isHollow()) {
                this.elements.add(new ElementReference(configuration, elementDescriptors[i], schema));
                continue;
            }
            if (elementDescriptors[i].isSimple()) {
                this.elements.add(new SimpleLocalElement(configuration, elementDescriptors[i], schema));
                continue;
            }
            this.elements.add(new ComplexLocalElement(configuration, elementDescriptors[i], schema));
        }
    }

    public List getElements() {
        return this.elements;
    }

    public void addElement(ElementReference element) {
        this.elements.add(element);
    }

    public void addElement(LocalElement element) {
        this.elements.add(element);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }
}

