/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.operations;

import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;

@Operation(id="Dam.Import", category="Dam", label="Create Asset(s) from file(s)", description="Create Asset(s) from Blob(s) using the FileManagerService inside the configured Asset Library or the current document.")
public class DamImport {
    public static final String ID = "Dam.Import";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Context
    protected FileManager fileManager;
    @Context
    protected DamService damService;
    @Context
    protected OperationContext context;
    @Context
    protected AutomationService as;
    @Param(name="overwrite", required=false)
    protected Boolean overwrite = false;
    @Param(name="importInCurrentDocument", required=false)
    protected Boolean importInCurrentDocument = false;

    protected DocumentModel getCurrentDocument() throws Exception {
        String cdRef = (String)this.context.get((Object)"currentDocument");
        return (DocumentModel)this.as.getAdaptedValue(this.context, (Object)cdRef, DocumentModel.class);
    }

    @OperationMethod
    public DocumentModel run(Blob blob) throws Exception {
        DocumentModel doc;
        AssetLibrary assetLibrary = this.damService.getAssetLibrary();
        String title = assetLibrary.getTitle();
        String path = assetLibrary.getPath();
        if (this.importInCurrentDocument.booleanValue() && (doc = this.getCurrentDocument()) != null) {
            title = doc.getTitle();
            path = doc.getPathAsString();
        }
        try {
            doc = this.fileManager.createDocumentFromBlob(this.session, blob, path, this.overwrite.booleanValue(), blob.getFilename());
            this.ctx.put("AddMessage.messageParams", (Object)new Object[]{1});
            return doc;
        }
        catch (ClientException e) {
            String[] params = new String[]{blob.getFilename(), title};
            throw new RecoverableClientException("Cannot import asset", "label.dam.import.asset.error", params, (Throwable)e);
        }
    }

    @OperationMethod
    public DocumentModelList run(BlobList blobs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (Blob blob : blobs) {
            result.add((Object)this.run(blob));
        }
        this.ctx.put("AddMessage.messageParams", (Object)new Object[]{result.size()});
        return result;
    }
}

