/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.BackOffPolicy;
import com.google.common.base.Preconditions;
import java.io.IOException;

public class ExponentialBackOffPolicy
implements BackOffPolicy {
    public static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 500;
    public static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final int DEFAULT_MAX_INTERVAL_MILLIS = 60000;
    public static final int DEFAULT_MAX_ELAPSED_TIME_MILLIS = 900000;
    private int currentIntervalMillis;
    private final int initialIntervalMillis;
    private final double randomizationFactor;
    private final double multiplier;
    private final int maxIntervalMillis;
    long startTimeNanos;
    private final int maxElapsedTimeMillis;

    public ExponentialBackOffPolicy() {
        this(500, 0.5, 1.5, 60000, 900000);
    }

    ExponentialBackOffPolicy(int initialIntervalMillis, double randomizationFactor, double multiplier, int maxIntervalMillis, int maxElapsedTimeMillis) {
        Preconditions.checkArgument((initialIntervalMillis > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((0.0 <= randomizationFactor && randomizationFactor < 1.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((multiplier >= 1.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxIntervalMillis >= initialIntervalMillis ? 1 : 0) != 0);
        Preconditions.checkArgument((maxElapsedTimeMillis > 0 ? 1 : 0) != 0);
        this.initialIntervalMillis = initialIntervalMillis;
        this.randomizationFactor = randomizationFactor;
        this.multiplier = multiplier;
        this.maxIntervalMillis = maxIntervalMillis;
        this.maxElapsedTimeMillis = maxElapsedTimeMillis;
        this.reset();
    }

    public boolean isBackOffRequired(int statusCode) {
        switch (statusCode) {
            case 500: 
            case 503: {
                return true;
            }
        }
        return false;
    }

    public final void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.startTimeNanos = System.nanoTime();
    }

    public long getNextBackOffMillis() throws IOException {
        if (this.getElapsedTimeMillis() > (long)this.maxElapsedTimeMillis) {
            return -1L;
        }
        int randomizedInterval = ExponentialBackOffPolicy.getRandomValueFromInterval(this.randomizationFactor, Math.random(), this.currentIntervalMillis);
        this.incrementCurrentInterval();
        return randomizedInterval;
    }

    static int getRandomValueFromInterval(double randomizationFactor, double random, int currentIntervalMillis) {
        double delta = randomizationFactor * (double)currentIntervalMillis;
        double minInterval = (double)currentIntervalMillis - delta;
        double maxInterval = (double)currentIntervalMillis + delta;
        int randomValue = (int)(minInterval + random * (maxInterval - minInterval + 1.0));
        return randomValue;
    }

    public final int getInitialIntervalMillis() {
        return this.initialIntervalMillis;
    }

    public final double getRandomizationFactor() {
        return this.randomizationFactor;
    }

    public final int getCurrentIntervalMillis() {
        return this.currentIntervalMillis;
    }

    public final double getMultiplier() {
        return this.multiplier;
    }

    public final int getMaxIntervalMillis() {
        return this.maxIntervalMillis;
    }

    public final int getMaxElapsedTimeMillis() {
        return this.maxElapsedTimeMillis;
    }

    public final long getElapsedTimeMillis() {
        return (System.nanoTime() - this.startTimeNanos) / 1000000L;
    }

    private void incrementCurrentInterval() {
        this.currentIntervalMillis = (double)this.currentIntervalMillis >= (double)this.maxIntervalMillis / this.multiplier ? this.maxIntervalMillis : (int)((double)this.currentIntervalMillis * this.multiplier);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int initialIntervalMillis = 500;
        private double randomizationFactor = 0.5;
        private double multiplier = 1.5;
        private int maxIntervalMillis = 60000;
        private int maxElapsedTimeMillis = 900000;

        protected Builder() {
        }

        public ExponentialBackOffPolicy build() {
            return new ExponentialBackOffPolicy(this.initialIntervalMillis, this.randomizationFactor, this.multiplier, this.maxIntervalMillis, this.maxElapsedTimeMillis);
        }

        public final int getInitialIntervalMillis() {
            return this.initialIntervalMillis;
        }

        public Builder setInitialIntervalMillis(int initialIntervalMillis) {
            this.initialIntervalMillis = initialIntervalMillis;
            return this;
        }

        public final double getRandomizationFactor() {
            return this.randomizationFactor;
        }

        public Builder setRandomizationFactor(double randomizationFactor) {
            this.randomizationFactor = randomizationFactor;
            return this;
        }

        public final double getMultiplier() {
            return this.multiplier;
        }

        public Builder setMultiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public final int getMaxIntervalMillis() {
            return this.maxIntervalMillis;
        }

        public Builder setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public final int getMaxElapsedTimeMillis() {
            return this.maxElapsedTimeMillis;
        }

        public Builder setMaxElapsedTimeMillis(int maxElapsedTimeMillis) {
            this.maxElapsedTimeMillis = maxElapsedTimeMillis;
            return this;
        }
    }
}

