/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.util;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Point;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPathUtil;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;

public class ImageRangeXPointer
implements XPointer {
    private final String url;
    private final String path;
    private final Point topLeft;
    private final Point bottomRight;
    private String xpointerString;

    public ImageRangeXPointer(String xpointer) {
        this.xpointerString = xpointer;
        this.url = xpointer.substring(0, xpointer.indexOf("#"));
        xpointer = xpointer.replaceFirst(".*image-range\\(", "");
        xpointer = xpointer.replaceFirst("\\)\\)$", "");
        String[] args = xpointer.split(",");
        this.path = args[0];
        this.topLeft = new Point(args[1] + "," + args[2]);
        this.bottomRight = new Point(args[3] + "," + args[4]);
    }

    @Override
    public String getMethod() {
        return "image-range";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getXPath() {
        return this.path;
    }

    public ImageElement getImage() {
        return this.getImage(false);
    }

    public ImageElement getImage(boolean multiImage) {
        Document document = Document.get();
        if (!multiImage) {
            String idablePath = XPathUtil.toIdableName(this.path);
            Element div = document.getElementById(idablePath);
            if (div == null) {
                return null;
            }
            return (ImageElement)div.getFirstChild();
        }
        return (ImageElement)document.getElementById("annotationRootImage");
    }

    public Point getTopLeft() {
        return this.topLeft;
    }

    public Point getBottomRight() {
        return this.bottomRight;
    }

    @Override
    public String getXpointerString() {
        return this.xpointerString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageRangeXPointer)) {
            return false;
        }
        ImageRangeXPointer xp = (ImageRangeXPointer)obj;
        return this.xpointerString.equals(xp.xpointerString);
    }

    public int hashCode() {
        int result = 17;
        return result += 17 * this.xpointerString.hashCode();
    }
}

