/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageAction;
import org.nuxeo.ecm.platform.mail.action.MessageActionPipe;

public class Visitor {
    private final MessageActionPipe pipe;

    public Visitor(MessageActionPipe pipe) {
        this.pipe = pipe;
    }

    public void visit(Folder folder) throws Exception {
        this.visit(folder, null);
    }

    public void visit(Folder folder, ExecutionContext initialContext) throws Exception {
        block2: for (Message message : folder.getMessages()) {
            ExecutionContext context = new ExecutionContext(message, initialContext);
            for (MessageAction action : this.pipe) {
                action.reset(context);
                boolean result = action.execute(context);
                if (result) continue;
                continue block2;
            }
        }
        Folder[] folders = new Folder[]{};
        try {
            folders = folder.list();
        }
        catch (MessagingException e) {
            // empty catch block
        }
        for (Folder f : folders) {
            this.visit(f, initialContext);
        }
    }

    public void visit(Message[] messages, ExecutionContext initialContext) throws Exception {
        block0: for (Message message : messages) {
            ExecutionContext context = new ExecutionContext(message, initialContext);
            for (MessageAction action : this.pipe) {
                action.reset(context);
                boolean result = action.execute(context);
                if (result) continue;
                continue block0;
            }
        }
    }
}

