/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.sax;

import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributesImpl;
import nu.validator.htmlparser.impl.TreeBuilder;
import nu.validator.saxtree.Characters;
import nu.validator.saxtree.Comment;
import nu.validator.saxtree.DTD;
import nu.validator.saxtree.Document;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.Element;
import nu.validator.saxtree.NodeType;
import nu.validator.saxtree.ParentNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SAXTreeBuilder
extends TreeBuilder<Element> {
    private Document document;

    SAXTreeBuilder() {
        super(XmlViolationPolicy.ALLOW, false);
    }

    @Override
    protected void appendComment(Element parent, char[] buf, int start, int length) {
        parent.appendChild(new Comment(this.tokenizer, buf, start, length));
    }

    @Override
    protected void appendCommentToDocument(char[] buf, int start, int length) {
        this.document.appendChild(new Comment(this.tokenizer, buf, start, length));
    }

    @Override
    protected void appendCharacters(Element parent, char[] buf, int start, int length) {
        parent.appendChild(new Characters(this.tokenizer, buf, start, length));
    }

    @Override
    protected void detachFromParent(Element element) {
        element.detach();
    }

    @Override
    protected boolean hasChildren(Element element) {
        return element.getFirstChild() != null;
    }

    @Override
    protected Element shallowClone(Element element) {
        Element newElt = new Element(element, element.getUri(), element.getLocalName(), element.getQName(), element.getAttributes(), true, element.getPrefixMappings());
        newElt.copyEndLocator(element);
        return newElt;
    }

    @Override
    protected void detachFromParentAndAppendToNewParent(Element child, Element newParent) {
        newParent.appendChild(child);
    }

    @Override
    protected Element createHtmlElementSetAsRoot(Attributes attributes) {
        Element newElt = new Element(this.tokenizer, "http://www.w3.org/1999/xhtml", "html", "html", attributes, true, null);
        this.document.appendChild(newElt);
        return newElt;
    }

    @Override
    protected void insertBefore(Element child, Element sibling, Element parent) {
        parent.insertBefore(child, sibling);
    }

    @Override
    protected Element parentElementFor(Element child) {
        ParentNode parent = child.getParentNode();
        if (parent == null) {
            return null;
        }
        if (parent.getNodeType() == NodeType.ELEMENT) {
            return (Element)parent;
        }
        return null;
    }

    @Override
    protected void addAttributesToElement(Element element, Attributes attributes) {
        AttributesImpl existingAttrs = (AttributesImpl)element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String qName = attributes.getQName(i);
            if (existingAttrs.getIndex(qName) >= 0) continue;
            existingAttrs.addAttribute(qName, attributes.getValue(i));
        }
    }

    @Override
    protected void appendDoctypeToDocument(String name, String publicIdentifier, String systemIdentifier) {
        DTD dtd = new DTD(this.tokenizer, name, publicIdentifier, systemIdentifier);
        dtd.setEndLocator(this.tokenizer);
        this.document.appendChild(dtd);
    }

    Document getDocument() {
        Document rv = this.document;
        this.document = null;
        return rv;
    }

    DocumentFragment getDocumentFragment() {
        DocumentFragment rv = new DocumentFragment();
        rv.appendChildren(this.document.getFirstChild());
        this.document = null;
        return rv;
    }

    @Override
    protected void end() throws SAXException {
        this.document.setEndLocator(this.tokenizer);
    }

    @Override
    protected void start(boolean fragment) {
        this.document = new Document(this.tokenizer);
    }

    @Override
    protected void appendChildrenToNewParent(Element oldParent, Element newParent) throws SAXException {
        newParent.appendChildren(oldParent);
    }

    @Override
    protected Element createElement(String name, Attributes attributes) throws SAXException {
        return new Element(this.tokenizer, "http://www.w3.org/1999/xhtml", name, name, attributes, true, null);
    }

    @Override
    protected void insertCharactersBefore(char[] buf, int start, int length, Element sibling, Element parent) throws SAXException {
        parent.insertBefore(new Characters(this.tokenizer, buf, start, length), sibling);
    }
}

