/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.BlobHelper;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingConfigurationDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureTemplate;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ImagingComponent
extends DefaultComponent
implements ImagingService {
    private static final Log log = LogFactory.getLog(ImagingComponent.class);
    public static final String CONFIGURATION_PARAMETERS_EP = "configuration";
    protected Map<String, String> configurationParameters = new HashMap<String, String>();
    private LibrarySelector librarySelector;

    public Blob crop(Blob blob, int x, int y, int width, int height) {
        try {
            return this.getLibrarySelectorService().getImageUtils().crop(blob, x, y, width, height);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return blob;
        }
    }

    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        try {
            return this.getLibrarySelectorService().getImageUtils().resize(blob, finalFormat, width, height, depth);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return blob;
        }
    }

    public Blob rotate(Blob blob, int angle) {
        try {
            return this.getLibrarySelectorService().getImageUtils().rotate(blob, angle);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return blob;
        }
    }

    public Map<String, Object> getImageMetadata(Blob blob) {
        try {
            return this.getLibrarySelectorService().getMetadataUtils().getImageMetadata(blob);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getImageMimeType(File file) {
        try {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            if (file.getName() != null) {
                return mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(file.getName(), (Blob)new FileBlob(file), "image/jpeg");
            }
            return mimetypeRegistry.getMimetypeFromFile(file);
        }
        catch (Exception e) {
            log.error((Object)"Unable to retrieve mime type", (Throwable)e);
            return null;
        }
    }

    public String getImageMimeType(Blob blob) {
        try {
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            if (blob.getFilename() != null) {
                return mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "image/jpeg");
            }
            return mimetypeRegistry.getMimetypeFromBlob(blob);
        }
        catch (Exception e) {
            log.error((Object)"Unable to retrieve mime type", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public String getImageMimeType(InputStream in) {
        try {
            return this.getLibrarySelectorService().getMimeUtils().getImageMimeType(in);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private LibrarySelector getLibrarySelectorService() throws ClientException {
        if (this.librarySelector == null) {
            this.librarySelector = (LibrarySelector)Framework.getRuntime().getService(LibrarySelector.class);
        }
        if (this.librarySelector == null) {
            log.error((Object)"Unable to get LibrarySelector runtime service");
            throw new ClientException("Unable to get LibrarySelector runtime service");
        }
        return this.librarySelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo getImageInfo(Blob blob) {
        ImageInfo imageInfo = null;
        File tmpFile = null;
        try {
            File file = BlobHelper.getFileFromBlob((Blob)blob);
            if (file == null) {
                tmpFile = File.createTempFile("nuxeoImageInfo", blob.getFilename() != null ? "." + FilenameUtils.getExtension((String)blob.getFilename()) : ".tmp");
                blob.transferTo(tmpFile);
                file = tmpFile;
            }
            imageInfo = ImageIdentifier.getInfo(file.getAbsolutePath());
        }
        catch (CommandNotAvailable e) {
            log.error((Object)("Failed to get ImageInfo for file " + blob.getFilename()), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Failed to tranfert file " + blob.getFilename()), (Throwable)e);
        }
        finally {
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
        return imageInfo;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIGURATION_PARAMETERS_EP.equals(extensionPoint)) {
            ImagingConfigurationDescriptor desc = (ImagingConfigurationDescriptor)contribution;
            this.configurationParameters.putAll(desc.getParameters());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIGURATION_PARAMETERS_EP.equals(extensionPoint)) {
            ImagingConfigurationDescriptor desc = (ImagingConfigurationDescriptor)contribution;
            for (String configuration : desc.getParameters().keySet()) {
                this.configurationParameters.remove(configuration);
            }
        }
    }

    public String getConfigurationValue(String configurationName) {
        return this.configurationParameters.get(configurationName);
    }

    public String getConfigurationValue(String configurationName, String defaultValue) {
        return this.configurationParameters.containsKey(configurationName) ? this.configurationParameters.get(configurationName) : defaultValue;
    }

    public void setConfigurationValue(String configurationName, String configurationValue) {
        this.configurationParameters.put(configurationName, configurationValue);
    }

    public PictureView computeViewFor(Blob blob, PictureTemplate pictureTemplate, boolean convert) throws IOException, ClientException {
        return this.computeViewFor(blob, pictureTemplate, null, convert);
    }

    public PictureView computeViewFor(Blob blob, PictureTemplate pictureTemplate, ImageInfo imageInfo, boolean convert) throws IOException, ClientException {
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            blob.setMimeType(this.getImageMimeType(blob));
        }
        if (imageInfo == null) {
            imageInfo = this.getImageInfo(blob);
        }
        return this.computeView(blob, pictureTemplate, imageInfo, convert);
    }

    public List<PictureView> computeViewsFor(Blob blob, List<PictureTemplate> pictureTemplates, boolean convert) throws IOException, ClientException {
        return this.computeViewsFor(blob, pictureTemplates, null, convert);
    }

    public List<PictureView> computeViewsFor(Blob blob, List<PictureTemplate> pictureTemplates, ImageInfo imageInfo, boolean convert) throws IOException, ClientException {
        String mimeType = blob.getMimeType();
        if (mimeType == null) {
            blob.setMimeType(this.getImageMimeType(blob));
        }
        if (imageInfo == null) {
            imageInfo = this.getImageInfo(blob);
        }
        ArrayList<PictureView> views = new ArrayList<PictureView>();
        for (PictureTemplate pictureTemplate : pictureTemplates) {
            views.add(this.computeView(blob, pictureTemplate, imageInfo, convert));
        }
        return views;
    }

    protected PictureView computeView(Blob blob, PictureTemplate pictureTemplate, ImageInfo imageInfo, boolean convert) throws IOException, ClientException {
        if (convert) {
            String title = pictureTemplate.getTitle();
            if ("Original".equals(title)) {
                return this.computeOriginalView(blob, pictureTemplate, imageInfo);
            }
            if ("OriginalJpeg".equals(title)) {
                return this.computeOriginalJpegView(blob, pictureTemplate, imageInfo);
            }
            return this.computeView(blob, pictureTemplate, imageInfo);
        }
        return this.computeViewWithoutConversion(blob, pictureTemplate, imageInfo);
    }

    protected PictureView computeOriginalView(Blob blob, PictureTemplate pictureTemplate, ImageInfo imageInfo) throws IOException {
        String filename = blob.getFilename();
        String title = pictureTemplate.getTitle();
        String viewFilename = title + "_" + filename;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", pictureTemplate.getTitle());
        map.put("description", pictureTemplate.getDescription());
        map.put("filename", viewFilename);
        map.put("tag", pictureTemplate.getTag());
        map.put("width", imageInfo.getWidth());
        map.put("height", imageInfo.getHeight());
        Blob originalViewBlob = this.copyBlob(blob);
        originalViewBlob.setMimeType(blob.getMimeType());
        originalViewBlob.setFilename(viewFilename);
        map.put("content", (Serializable)originalViewBlob);
        return new PictureViewImpl(map);
    }

    protected Blob copyBlob(Blob blob) throws IOException {
        Blob persistedBlob = blob.persist();
        return new InputStreamBlob(persistedBlob.getStream());
    }

    protected PictureView computeOriginalJpegView(Blob blob, PictureTemplate pictureTemplate, ImageInfo imageInfo) throws ClientException, IOException {
        String filename = blob.getFilename();
        String title = pictureTemplate.getTitle();
        int width = imageInfo.getWidth();
        int height = imageInfo.getHeight();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", pictureTemplate.getTitle());
        map.put("description", pictureTemplate.getDescription());
        map.put("tag", pictureTemplate.getTag());
        map.put("width", width);
        map.put("height", height);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("width", width);
        options.put("height", height);
        options.put("depth", imageInfo.getDepth());
        options.put("conversionFormat", "jpg");
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
        bh = conversionService.convert("pictureResize", (BlobHolder)bh, options);
        Blob originalJpegBlob = bh.getBlob();
        if (originalJpegBlob == null) {
            originalJpegBlob = this.copyBlob(blob);
            originalJpegBlob.setMimeType(blob.getMimeType());
        }
        String viewFilename = this.computeViewFilename(filename, "jpg");
        viewFilename = title + "_" + viewFilename;
        map.put("filename", viewFilename);
        originalJpegBlob.setFilename(viewFilename);
        map.put("content", (Serializable)originalJpegBlob);
        return new PictureViewImpl(map);
    }

    protected String computeViewFilename(String filename, String format) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return filename + "." + format;
        }
        return filename.substring(0, index + 1) + format;
    }

    protected PictureView computeView(Blob blob, PictureTemplate pictureTemplate, ImageInfo imageInfo) throws ClientException, IOException {
        String filename = blob.getFilename();
        String title = pictureTemplate.getTitle();
        int width = imageInfo.getWidth();
        int height = imageInfo.getHeight();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", pictureTemplate.getTitle());
        map.put("description", pictureTemplate.getDescription());
        map.put("tag", pictureTemplate.getTag());
        Point size = new Point(width, height);
        size = ImagingComponent.getSize(size, pictureTemplate.getMaxSize());
        map.put("width", size.x);
        map.put("height", size.y);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("width", size.x);
        options.put("height", size.y);
        options.put("depth", imageInfo.getDepth());
        String conversionFormat = this.getConfigurationValue("conversionFormat", "jpg");
        options.put("conversionFormat", conversionFormat);
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
        bh = conversionService.convert("pictureResize", (BlobHolder)bh, options);
        Blob viewBlob = bh.getBlob();
        if (viewBlob == null) {
            viewBlob = this.copyBlob(blob);
            viewBlob.setMimeType(blob.getMimeType());
        }
        String viewFilename = this.computeViewFilename(filename, conversionFormat);
        viewFilename = title + "_" + viewFilename;
        map.put("filename", viewFilename);
        viewBlob.setFilename(viewFilename);
        map.put("content", (Serializable)viewBlob);
        return new PictureViewImpl(map);
    }

    protected PictureView computeViewWithoutConversion(Blob blob, PictureTemplate pictureTemplate, ImageInfo imageInfo) {
        PictureViewImpl view = new PictureViewImpl();
        view.setBlob(blob);
        view.setWidth(imageInfo.getWidth());
        view.setHeight(imageInfo.getHeight());
        view.setFilename(blob.getFilename());
        view.setTitle(pictureTemplate.getTitle());
        view.setDescription(pictureTemplate.getDescription());
        view.setTag(pictureTemplate.getTag());
        return view;
    }

    protected static Point getSize(Point current, int max) {
        int newX;
        int newY;
        int x = current.x;
        int y = current.y;
        if (x > y) {
            newY = y * max / x;
            newX = max;
        } else {
            newX = x * max / y;
            newY = max;
        }
        if (newX > x || newY > y) {
            return current;
        }
        return new Point(newX, newY);
    }

    public List<List<PictureView>> computeViewsFor(List<Blob> blobs, List<PictureTemplate> pictureTemplates, boolean convert) throws IOException, ClientException {
        return this.computeViewsFor(blobs, pictureTemplates, null, convert);
    }

    public List<List<PictureView>> computeViewsFor(List<Blob> blobs, List<PictureTemplate> pictureTemplates, ImageInfo imageInfo, boolean convert) throws IOException, ClientException {
        ArrayList<List<PictureView>> allViews = new ArrayList<List<PictureView>>();
        for (Blob blob : blobs) {
            allViews.add(this.computeViewsFor(blob, pictureTemplates, imageInfo, convert));
        }
        return allViews;
    }
}

