/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.opensocial;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.InputSource;
import com.google.caja.opensocial.UriCallback;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.reporting.MessageContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Callback
implements UriCallback {
    private MessageContext mc;
    private Map<InputSource, CharSequence> originalSources;

    public Callback(MessageContext mc, Map<InputSource, CharSequence> originalSources) {
        this.mc = mc;
        this.originalSources = originalSources;
    }

    @Override
    public Reader retrieve(ExternalReference extref, String mimeType) throws UriCallbackException {
        InputStreamReader in;
        URI uri;
        try {
            uri = extref.getUri();
            in = new InputStreamReader(uri.toURL().openStream(), "UTF-8");
        }
        catch (IOException e) {
            throw new UriCallbackException(extref, (Throwable)e);
        }
        final StringBuilder originalSource = new StringBuilder();
        InputSource is = new InputSource(uri);
        this.originalSources.put(is, originalSource);
        this.mc.addInputSource(is);
        return new Reader(){

            public void close() throws IOException {
                in.close();
            }

            public int read(char[] cbuf, int off, int len) throws IOException {
                int n = in.read(cbuf, off, len);
                if (n > 0) {
                    originalSource.append(cbuf, off, n);
                }
                return n;
            }

            public int read() throws IOException {
                int ch = in.read();
                if (ch >= 0) {
                    originalSource.append((char)ch);
                }
                return ch;
            }
        };
    }

    @Override
    public URI rewrite(ExternalReference extref, String mimeType) {
        return extref.getUri();
    }
}

