/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.html.AbstractElementStack;
import com.google.caja.parser.html.AttrStub;
import com.google.caja.parser.html.DoctypeMaker;
import com.google.caja.parser.html.DomParserMessageType;
import com.google.caja.parser.html.IllegalDocumentStateException;
import com.google.caja.parser.html.LookaheadLexer;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.html.OpenElementStack;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Function;
import com.google.caja.util.Lists;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomParser {
    private final TokenQueue<HtmlTokenType> tokens;
    private final boolean asXml;
    private final MessageQueue mq;
    private final Namespaces ns;
    private boolean needsDebugData = true;
    private boolean wantsComments = false;
    private DOMImplementation domImpl = null;
    private static final Pattern AMBIGUOUS_VALUE = Pattern.compile("^\\w+\\s*=");

    public DomParser(TokenQueue<HtmlTokenType> tokens, boolean asXml, MessageQueue mq) {
        this(tokens, asXml, Namespaces.HTML_DEFAULT, mq);
    }

    public DomParser(TokenQueue<HtmlTokenType> tokens, boolean asXml, Namespaces ns, MessageQueue mq) {
        this.tokens = tokens;
        this.asXml = asXml;
        this.ns = ns;
        this.mq = mq;
    }

    public DomParser(HtmlLexer lexer, InputSource src, MessageQueue mq) throws ParseException {
        this(lexer, src, Namespaces.HTML_DEFAULT, mq);
    }

    public DomParser(HtmlLexer lexer, InputSource src, Namespaces ns, MessageQueue mq) throws ParseException {
        this.mq = mq;
        this.ns = ns;
        LookaheadLexer la = new LookaheadLexer(lexer);
        this.asXml = ns.forPrefix((String)"").uri != Namespaces.HTML_NAMESPACE_URI || DomParser.guessAsXml(la, src);
        lexer.setTreatedAsXml(this.asXml);
        this.tokens = new TokenQueue<HtmlTokenType>(la, src);
    }

    public TokenQueue<HtmlTokenType> getTokenQueue() {
        return this.tokens;
    }

    public boolean asXml() {
        return this.asXml;
    }

    public void setNeedsDebugData(boolean needsDebugData) {
        this.needsDebugData = needsDebugData;
    }

    protected OpenElementStack makeElementStack(Document doc, MessageQueue mq) {
        String sysid;
        String nsUri;
        Namespaces ns = this.ns;
        DocumentType doctype = doc.getDoctype();
        if (doctype != null && (nsUri = DoctypeMaker.systemIdToNsUri(sysid = doctype.getSystemId())) != null) {
            ns = new Namespaces(ns, "", nsUri);
        }
        return this.asXml ? OpenElementStack.Factory.createXmlElementStack(doc, this.needsDebugData, ns, mq) : OpenElementStack.Factory.createHtml5ElementStack(doc, this.needsDebugData, mq);
    }

    public void setDomImpl(DOMImplementation domImpl) {
        this.domImpl = domImpl;
    }

    public void setWantsComments(boolean wantsComments) {
        this.wantsComments = wantsComments;
    }

    public static Document makeDocument(Function<DOMImplementation, DocumentType> doctypeMaker, String features, DOMImplementation domImpl) {
        if (features == null) {
            features = "XML 1.0 Traversal";
        }
        if (domImpl == null) {
            try {
                domImpl = DOMImplementationRegistry.newInstance().getDOMImplementation(features);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Missing DOM implementation.  Is Xerces on the classpath?", ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("Missing DOM implementation.  Is Xerces on the classpath?", ex);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException("Missing DOM implementation.  Is Xerces on the classpath?", ex);
            }
        }
        DocumentType doctype = doctypeMaker != null ? doctypeMaker.apply(domImpl) : null;
        return domImpl.createDocument(null, null, doctype);
    }

    public static Document makeDocument(Function<DOMImplementation, DocumentType> doctypeMaker, String features) {
        return DomParser.makeDocument(doctypeMaker, features, null);
    }

    public Element parseDocument() throws ParseException {
        return this.parseDocument(null);
    }

    public Element parseDocument(String features) throws ParseException {
        Function<DOMImplementation, DocumentType> doctypeMaker = this.findDoctype();
        Document doc = DomParser.makeDocument(doctypeMaker, features, this.domImpl);
        OpenElementStack elementStack = this.makeElementStack(doc, this.mq);
        elementStack.open(false);
        do {
            Token<HtmlTokenType> t = this.tokens.peek();
            if (HtmlTokenType.TEXT == t.type ? !"".equals(t.text.trim()) : HtmlTokenType.COMMENT != t.type && HtmlTokenType.DIRECTIVE != t.type) break;
            this.tokens.advance();
        } while (!this.tokens.isEmpty());
        do {
            this.parseDom(elementStack);
        } while (!this.tokens.isEmpty());
        FilePosition endPos = FilePosition.endOf(this.tokens.lastPosition());
        try {
            elementStack.finish(endPos);
        }
        catch (IllegalDocumentStateException ex) {
            throw new ParseException(ex.getCajaMessage(), (Throwable)ex);
        }
        DocumentFragment root = elementStack.getRootElement();
        Node firstChild = root.getFirstChild();
        if (firstChild == null || firstChild.getNodeType() != 1) {
            throw new ParseException(new Message((MessageTypeInt)DomParserMessageType.MISSING_DOCUMENT_ELEMENT, endPos));
        }
        block8: for (Node child = firstChild.getNextSibling(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 8: 
                case 10: {
                    continue block8;
                }
                case 3: {
                    if ("".equals(child.getNodeValue().trim())) continue block8;
                }
                default: {
                    throw new ParseException(new Message((MessageTypeInt)DomParserMessageType.MISPLACED_CONTENT, Nodes.getFilePositionFor(child)));
                }
            }
        }
        doc.appendChild(firstChild);
        if (elementStack.needsNamespaceFixup()) {
            this.fixup(firstChild, this.ns);
        }
        return (Element)firstChild;
    }

    public DocumentFragment parseFragment() throws ParseException {
        return this.parseFragment(DomParser.makeDocument(this.findDoctype(), null, this.domImpl));
    }

    public DocumentFragment parseFragment(Document doc) throws ParseException {
        OpenElementStack elementStack = this.makeElementStack(doc, this.mq);
        elementStack.open(true);
        block5: while (!this.tokens.isEmpty()) {
            Token<HtmlTokenType> t = this.tokens.peek();
            switch ((HtmlTokenType)t.type) {
                case DIRECTIVE: {
                    this.tokens.advance();
                    continue block5;
                }
            }
            this.parseDom(elementStack);
        }
        FilePosition endPos = this.tokens.lastPosition();
        endPos = endPos != null ? FilePosition.endOf(endPos) : FilePosition.startOfFile(this.tokens.getInputSource());
        try {
            elementStack.finish(endPos);
        }
        catch (IllegalDocumentStateException ex) {
            throw new ParseException(ex.getCajaMessage(), (Throwable)ex);
        }
        DocumentFragment fragment = elementStack.getRootElement();
        if (elementStack.needsNamespaceFixup()) {
            this.fixup(fragment, this.ns);
        }
        return fragment;
    }

    private void fixup(Node node, Namespaces ns) {
        switch (node.getNodeType()) {
            case 1: {
                boolean modifiedAttrs;
                Attr a;
                Namespaces elNs;
                Element el = (Element)node;
                Document doc = el.getOwnerDocument();
                boolean hasNamespaceAttrs = false;
                NamedNodeMap attrs = el.getAttributes();
                int n = attrs.getLength();
                for (int i = 0; i < n; ++i) {
                    String name;
                    Attr a2 = (Attr)attrs.item(i);
                    if (a2.getNamespaceURI() != null || !(name = a2.getName()).startsWith("xmlns:")) continue;
                    hasNamespaceAttrs = true;
                    String prefix = name.substring(6);
                    String uri = a2.getValue();
                    ns = new Namespaces(ns, prefix, uri);
                }
                if (el.getNamespaceURI() == null) {
                    Node child;
                    String qname = el.getTagName();
                    elNs = ns.forElementName(qname);
                    if (elNs == null) {
                        FilePosition pos = Nodes.getFilePositionFor(el);
                        ns = elNs = AbstractElementStack.unknownNamespace(pos, ns, qname, this.mq);
                    }
                    String localName = qname.substring(qname.indexOf(58) + 1);
                    Element replacement = doc.createElementNS(elNs.uri, localName);
                    replacement.setPrefix(elNs.prefix);
                    el.getParentNode().replaceChild(replacement, el);
                    while ((child = el.getFirstChild()) != null) {
                        replacement.appendChild(child);
                    }
                    NamedNodeMap attrs2 = el.getAttributes();
                    while (attrs2.getLength() != 0) {
                        a = (Attr)attrs2.item(0);
                        el.removeAttributeNode(a);
                        replacement.setAttributeNodeNS(a);
                    }
                    if (this.needsDebugData) {
                        Nodes.setFilePositionFor(replacement, Nodes.getFilePositionFor(el));
                    }
                    el = replacement;
                    node = el;
                } else {
                    elNs = ns.forUri(el.getNamespaceURI());
                    if (elNs == null) {
                        FilePosition pos = Nodes.getFilePositionFor(el);
                        ns = elNs = AbstractElementStack.unknownNamespace(pos, ns, el.getTagName(), this.mq);
                    }
                }
                do {
                    modifiedAttrs = false;
                    NamedNodeMap attrs3 = el.getAttributes();
                    int n2 = attrs3.getLength();
                    for (int i = 0; i < n2; ++i) {
                        a = (Attr)attrs3.item(i);
                        String qname = a.getName();
                        if (hasNamespaceAttrs && qname.startsWith("xmlns:")) {
                            el.removeAttributeNode(a);
                            modifiedAttrs = true;
                            continue;
                        }
                        if (a.getNamespaceURI() != null) continue;
                        String localName = qname.substring(qname.indexOf(58) + 1);
                        Namespaces attrNs = ns.forAttrName(elNs, qname);
                        if (attrNs == null) {
                            FilePosition pos = Nodes.getFilePositionFor(a);
                            ns = attrNs = AbstractElementStack.unknownNamespace(pos, ns, qname, this.mq);
                        }
                        Attr newAttr = doc.createAttributeNS(attrNs.uri, localName);
                        if (attrNs.uri != elNs.uri) {
                            newAttr.setPrefix(attrNs.prefix);
                        }
                        newAttr.setValue(a.getValue());
                        if (this.needsDebugData) {
                            Nodes.setFilePositionFor(newAttr, Nodes.getFilePositionFor(a));
                            Nodes.setFilePositionForValue(newAttr, Nodes.getFilePositionForValue(a));
                            Nodes.setRawValue(newAttr, Nodes.getRawValue(a));
                        }
                        el.removeAttributeNode(a);
                        el.setAttributeNodeNS(newAttr);
                        modifiedAttrs = true;
                    }
                } while (modifiedAttrs);
                break;
            }
            case 11: {
                break;
            }
            default: {
                return;
            }
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
            this.fixup(c, ns);
        }
    }

    public static TokenQueue<HtmlTokenType> makeTokenQueue(InputSource is, Reader in, boolean asXml) throws IOException {
        return DomParser.makeTokenQueue(FilePosition.startOfFile(is), in, asXml);
    }

    public static TokenQueue<HtmlTokenType> makeTokenQueue(FilePosition pos, Reader in, boolean asXml) throws IOException {
        CharProducer cp = CharProducer.Factory.create(in, pos);
        HtmlLexer lexer = new HtmlLexer(cp);
        lexer.setTreatedAsXml(asXml);
        return new TokenQueue<HtmlTokenType>(lexer, pos.source());
    }

    private void parseDom(OpenElementStack out) throws ParseException {
        Token<HtmlTokenType> t;
        block7: while (true) {
            t = this.tokens.pop();
            switch ((HtmlTokenType)t.type) {
                case TAGBEGIN: {
                    Token<HtmlTokenType> end;
                    List<AttrStub> attribs;
                    if (DomParser.isClose(t)) {
                        attribs = Collections.emptyList();
                        while (true) {
                            end = this.tokens.pop();
                            if (end.type != HtmlTokenType.TAGEND) {
                                if (end.type == HtmlTokenType.IGNORABLE) continue;
                                this.mq.addMessage((MessageTypeInt)DomParserMessageType.IGNORING_TOKEN, end.pos, MessagePart.Factory.valueOf(end.text));
                                continue;
                            }
                            break;
                        }
                    } else {
                        attribs = Lists.newArrayList();
                        end = this.parseTagAttributes(t.pos, attribs);
                    }
                    try {
                        out.processTag(t, end, attribs);
                    }
                    catch (IllegalDocumentStateException ex) {
                        throw new ParseException(ex.getCajaMessage(), (Throwable)ex);
                    }
                    return;
                }
                case CDATA: 
                case TEXT: 
                case UNESCAPED: {
                    out.processText(t);
                    return;
                }
                case COMMENT: {
                    if (!this.wantsComments) continue block7;
                    out.processComment(t);
                    continue block7;
                }
            }
            break;
        }
        throw new ParseException(new Message((MessageTypeInt)MessageType.MALFORMED_XHTML, t.pos, MessagePart.Factory.valueOf(t.text)));
    }

    private Token<HtmlTokenType> parseTagAttributes(FilePosition start, List<? super AttrStub> attrs) throws ParseException {
        Token<HtmlTokenType> last;
        block4: while (true) {
            last = this.tokens.peek();
            switch ((HtmlTokenType)last.type) {
                case TAGEND: {
                    this.tokens.advance();
                    break block4;
                }
                case ATTRNAME: {
                    AttrStub a = this.parseAttrib();
                    if (a == null) continue block4;
                    attrs.add(a);
                    break;
                }
                default: {
                    throw new ParseException(new Message((MessageTypeInt)MessageType.MALFORMED_XHTML, FilePosition.span(start, last.pos), MessagePart.Factory.valueOf(last.text)));
                }
            }
        }
        return last;
    }

    private AttrStub parseAttrib() throws ParseException {
        String decodedValue;
        String rawValue;
        int vlen;
        Token<HtmlTokenType> name = this.tokens.pop();
        Token<HtmlTokenType> value = this.tokens.peek();
        if (value.type == HtmlTokenType.ATTRVALUE) {
            this.tokens.advance();
            if (DomParser.isAmbiguousAttributeValue(value.text)) {
                this.mq.addMessage((MessageTypeInt)MessageType.AMBIGUOUS_ATTRIBUTE_VALUE, FilePosition.span(name.pos, value.pos), MessagePart.Factory.valueOf(name.text), MessagePart.Factory.valueOf(value.text));
            }
        } else {
            if (this.asXml) {
                throw new ParseException(new Message((MessageTypeInt)MessageType.MISSING_ATTRIBUTE_VALUE, value.pos, MessagePart.Factory.valueOf(value.text)));
            }
            value = Token.instance(name.text, HtmlTokenType.ATTRVALUE, name.pos);
        }
        if ((vlen = (rawValue = value.text).length()) >= 2) {
            char ch0 = rawValue.charAt(0);
            char chn = rawValue.charAt(vlen - 1);
            int start = 0;
            int end = vlen;
            if (chn == '\"' || chn == '\'') {
                --end;
                if (ch0 == chn) {
                    start = 1;
                }
            }
            decodedValue = Nodes.decode(rawValue.substring(start, end));
        } else {
            decodedValue = Nodes.decode(rawValue);
        }
        return new AttrStub(name, value, decodedValue);
    }

    private static boolean isClose(Token<HtmlTokenType> t) {
        return t.text.startsWith("</");
    }

    private static boolean guessAsXml(LookaheadLexer la, InputSource is) throws ParseException {
        String path;
        Token<HtmlTokenType> first = la.peek();
        Token<HtmlTokenType> firstNonSpace = first;
        if (firstNonSpace != null && "".equals(firstNonSpace.text.trim())) {
            Token<HtmlTokenType> space = firstNonSpace;
            la.next();
            firstNonSpace = la.peek();
            la.pushBack(space);
        }
        if (firstNonSpace == null) {
            return false;
        }
        switch ((HtmlTokenType)firstNonSpace.type) {
            case DIRECTIVE: {
                return firstNonSpace.text.startsWith("<?xml") || firstNonSpace.text.startsWith("<!DOCTYPE") && !DomParser.isHtmlDoctype(firstNonSpace.text);
            }
            case TAGBEGIN: {
                if (firstNonSpace.text.indexOf(58) < 0) break;
                return true;
            }
        }
        if (FilePosition.startOf(first.pos).equals(FilePosition.startOfFile(first.pos.source())) && (path = is.getUri().getPath()) != null) {
            String ext = Strings.toLowerCase(path.substring(path.lastIndexOf(46) + 1));
            if ("html".equals(ext)) {
                return false;
            }
            if ("xml".equals(ext) || "xhtml".equals(ext)) {
                return true;
            }
        }
        return false;
    }

    private Function<DOMImplementation, DocumentType> findDoctype() throws ParseException {
        if (this.tokens.isEmpty()) {
            return null;
        }
        Function<DOMImplementation, DocumentType> doctypeMaker = null;
        TokenQueue.Mark start = this.tokens.mark();
        block4: while (!this.tokens.isEmpty()) {
            Token<HtmlTokenType> t = this.tokens.peek();
            switch ((HtmlTokenType)t.type) {
                case COMMENT: 
                case IGNORABLE: {
                    this.tokens.pop();
                    continue block4;
                }
                case DIRECTIVE: {
                    this.tokens.pop();
                    final Function<DOMImplementation, DocumentType> maker = DoctypeMaker.parse(t.text);
                    if (maker == null) continue block4;
                    final FilePosition pos = t.pos;
                    doctypeMaker = new Function<DOMImplementation, DocumentType>(){

                        @Override
                        public DocumentType apply(DOMImplementation impl) {
                            DocumentType t = (DocumentType)maker.apply(impl);
                            Nodes.setFilePositionFor(t, pos);
                            return t;
                        }
                    };
                    break;
                }
            }
            break;
        }
        this.tokens.rewind(start);
        return doctypeMaker;
    }

    private static boolean isHtmlDoctype(String s) {
        return Pattern.compile("(?i:^<!DOCTYPE\\s+HTML\\b)").matcher(s).find() && !Pattern.compile("(?i:\\bXHTML\\b)").matcher(s).find();
    }

    private static boolean isAmbiguousAttributeValue(String attributeText) {
        return AMBIGUOUS_VALUE.matcher(attributeText).find();
    }
}

