/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.activity.ActivityLinkBuilder;
import org.nuxeo.ecm.activity.ActivityLinkBuilderDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActivityLinkBuilderRegistry
extends ContributionFragmentRegistry<ActivityLinkBuilderDescriptor> {
    protected Map<String, ActivityLinkBuilder> activityLinkBuilders = new HashMap<String, ActivityLinkBuilder>();
    protected List<String> activityLinkBuildersIds = new ArrayList<String>();

    public ActivityLinkBuilder getDefaultActivityLinkBuilder() {
        if (this.activityLinkBuildersIds.isEmpty()) {
            throw new IllegalStateException("No default ActivityLinkBuilder configured");
        }
        return this.activityLinkBuilders.get(this.activityLinkBuildersIds.get(0));
    }

    public ActivityLinkBuilder get(String name) {
        return this.activityLinkBuilders.get(name);
    }

    public String getContributionId(ActivityLinkBuilderDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ActivityLinkBuilderDescriptor contrib, ActivityLinkBuilderDescriptor newOrigContrib) {
        this.activityLinkBuilders.put(id, contrib.getActivityLinkBuilder());
        if (contrib.isDefault()) {
            this.activityLinkBuildersIds.add(0, id);
        }
    }

    public void contributionRemoved(String id, ActivityLinkBuilderDescriptor origContrib) {
        this.activityLinkBuilders.remove(id);
        this.activityLinkBuildersIds.remove(id);
    }

    public ActivityLinkBuilderDescriptor clone(ActivityLinkBuilderDescriptor orig) {
        return orig.clone();
    }

    public void merge(ActivityLinkBuilderDescriptor src, ActivityLinkBuilderDescriptor dst) {
        boolean enabled;
        boolean isDefault;
        Class<? extends ActivityLinkBuilder> clazz = src.getActivityLinkBuilderClass();
        if (clazz != null) {
            dst.setActivityLinkBuilderClass(clazz);
        }
        if ((isDefault = src.isDefault()) != dst.isDefault()) {
            dst.setDefault(isDefault);
        }
        if ((enabled = src.isEnabled()) != dst.isEnabled()) {
            dst.setEnabled(enabled);
        }
    }
}

