/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.seam;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.runtime.api.Framework;

@Name(value="damBulkEditActions")
@Scope(value=org.jboss.seam.ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamBulkEditActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient CoreSession documentManager;

    @Observer(value={"selectionEdited"})
    public void addTagsOnSelection(List<DocumentModel> selectedDocuments, DocumentModel bulkEditDoc) throws ClientException {
        List tags = (List)((Object)bulkEditDoc.getContextData(ScopeType.REQUEST, "dam_bulk_edit_tags"));
        if (tags != null && !tags.isEmpty()) {
            TagService tagService = (TagService)Framework.getLocalService(TagService.class);
            String username = this.documentManager.getPrincipal().getName();
            for (DocumentModel doc : selectedDocuments) {
                for (String tag : tags) {
                    tagService.tag(this.documentManager, doc.getId(), tag, username);
                }
            }
        }
    }
}

