/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.dbcp.managed.BasicManagedDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.datasource.BasicManagedDataSourceFactory;
import org.nuxeo.runtime.datasource.LazyTransactionManager;

public class DataSourceFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(DataSourceFactory.class);
    private static final String URL_UPPER = "URL";
    private static final String URL_LOWER = "url";
    private static final String[] TOMCAT_PROPERTIES = new String[]{"scope", "auth", "factory"};
    public static final Set<String> SYSTEM_PROPERTIES;
    protected final Map<Name, DataSource> datasourcesByName = new HashMap<Name, DataSource>();

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        DataSource ds;
        BasicManagedDataSourceFactory factory;
        if (this.datasourcesByName.containsKey(name)) {
            return this.datasourcesByName.get(name);
        }
        Reference ref = (Reference)obj;
        if (!DataSource.class.getName().equals(ref.getClassName())) {
            return null;
        }
        boolean xa = ref.get("xaDataSource") != null;
        log.info((Object)String.format("Creating pooled %s datasource: %s", xa ? "XA" : "non-XA", name));
        HashMap<String, String> properties = new HashMap<String, String>();
        Enumeration<RefAddr> refAddrs = ref.getAll();
        while (refAddrs.hasMoreElements()) {
            RefAddr ra = refAddrs.nextElement();
            String key = ra.getType();
            String value = ra.getContent().toString();
            if (SYSTEM_PROPERTIES.contains(key)) continue;
            properties.put(key, value);
        }
        if (!xa) {
            for (Map.Entry en : properties.entrySet()) {
                if (!URL_LOWER.equalsIgnoreCase((String)en.getKey())) continue;
                ref.add(new StringRefAddr(URL_LOWER, (String)en.getValue()));
            }
            factory = new BasicDataSourceFactory();
            ds = (DataSource)factory.getObjectInstance(ref, name, nameCtx, env);
            BasicDataSource bds = (BasicDataSource)ds;
            for (Map.Entry en : properties.entrySet()) {
                String key = (String)en.getKey();
                if (URL_LOWER.equalsIgnoreCase(key)) continue;
                bds.addConnectionProperty(key, (String)en.getValue());
            }
        } else {
            factory = new BasicManagedDataSourceFactory();
            ds = (DataSource)factory.getObjectInstance(obj, name, nameCtx, env);
            if (ds == null) {
                return null;
            }
            BasicManagedDataSource bmds = (BasicManagedDataSource)ds;
            bmds.setTransactionManager((TransactionManager)new LazyTransactionManager());
            XADataSource xaDataSource = bmds.getXaDataSourceInstance();
            if (xaDataSource == null) {
                return null;
            }
            for (Map.Entry en : properties.entrySet()) {
                boolean ok;
                String value;
                String key;
                block15: {
                    key = (String)en.getKey();
                    if (Character.isLowerCase(key.charAt(1))) {
                        key = Character.toLowerCase(key.charAt(0)) + key.substring(1);
                    }
                    value = (String)en.getValue();
                    ok = false;
                    try {
                        BeanUtils.setProperty((Object)xaDataSource, (String)key, (Object)value);
                        ok = true;
                    }
                    catch (Exception e) {
                        if (!URL_LOWER.equals(key)) break block15;
                        try {
                            BeanUtils.setProperty((Object)xaDataSource, (String)URL_UPPER, (Object)value);
                            ok = true;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                }
                if (ok) continue;
                log.error((Object)String.format("Cannot set %s = %s on %s", key, value, xaDataSource.getClass().getName()));
            }
        }
        return ds;
    }

    static {
        HashSet<String> props = new HashSet<String>(Arrays.asList(BasicManagedDataSourceFactory.ALL_PROPERTIES));
        props.addAll(Arrays.asList(TOMCAT_PROPERTIES));
        SYSTEM_PROPERTIES = Collections.unmodifiableSet(props);
    }
}

