/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;

public class AclService {

    public static class ApplyACL
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            AclPropagation aclPropagation = this.getEnumParameter(request, "ACLPropagation", AclPropagation.class);
            ControlParser cp = new ControlParser(request);
            Acl acl = service.applyAcl(repositoryId, objectId, this.createAddAcl(cp), this.createRemoveAcl(cp), aclPropagation, null);
            this.setStatus(request, response, 201);
            JSONObject jsonObject = JSONConverter.convert((Acl)acl);
            if (jsonObject == null) {
                jsonObject = new JSONObject();
            }
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class GetACL
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            Boolean onlyBasicPermissions = this.getBooleanParameter(request, "onlyBasicPermissions");
            Acl acl = service.getAcl(repositoryId, objectId, onlyBasicPermissions, null);
            response.setStatus(200);
            JSONObject jsonObject = JSONConverter.convert((Acl)acl);
            if (jsonObject == null) {
                jsonObject = new JSONObject();
            }
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }
}

