/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mp4FtypBox
extends AbstractMp4Box {
    private String majorBrand;
    private int majorBrandVersion;
    private List<String> compatibleBrands = new ArrayList<String>();
    private static final int MAJOR_BRAND_POS = 0;
    private static final int MAJOR_BRAND_LENGTH = 4;
    private static final int MAJOR_BRAND_VERSION_POS = 4;
    private static final int MAJOR_BRAND_VERSION_LENGTH = 4;
    private static final int COMPATIBLE_BRAND_LENGTH = 4;

    public Mp4FtypBox(Mp4BoxHeader header, ByteBuffer dataBuffer) {
        this.header = header;
        this.dataBuffer = dataBuffer;
    }

    public void processData() throws CannotReadException {
        CharsetDecoder decoder = Charset.forName("ISO-8859-1").newDecoder();
        try {
            this.majorBrand = decoder.decode((ByteBuffer)this.dataBuffer.slice().limit(4)).toString();
        }
        catch (CharacterCodingException cee) {
            // empty catch block
        }
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        this.majorBrandVersion = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        while (this.dataBuffer.position() < this.dataBuffer.limit() && this.dataBuffer.limit() - this.dataBuffer.position() >= 4) {
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            try {
                String brand = decoder.decode((ByteBuffer)this.dataBuffer.slice().limit(4)).toString();
                if (!brand.equals("\u0000\u0000\u0000\u0000")) {
                    this.compatibleBrands.add(brand);
                }
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
            this.dataBuffer.position(this.dataBuffer.position() + 4);
        }
    }

    public String toString() {
        String info = "Major Brand:" + this.majorBrand + "Version:" + this.majorBrandVersion;
        if (this.compatibleBrands.size() > 0) {
            info = info + "Compatible:";
            for (String brand : this.compatibleBrands) {
                info = info + brand;
                info = info + ",";
            }
            return info.substring(0, info.length() - 1);
        }
        return info;
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public int getMajorBrandVersion() {
        return this.majorBrandVersion;
    }

    public List<String> getCompatibleBrands() {
        return this.compatibleBrands;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Brand {
        ISO14496_1_BASE_MEDIA("isom", "ISO 14496-1"),
        ISO14496_12_BASE_MEDIA("iso2", "ISO 14496-12"),
        ISO14496_1_VERSION_1("mp41", "ISO 14496-1"),
        ISO14496_1_VERSION_2("mp42", "ISO 14496-2:Multi track with BIFS scenes"),
        QUICKTIME_MOVIE("qt  ", "Original Quicktime"),
        JVT_AVC("avc1", "JVT"),
        THREEG_MOBILE_MP4("MPA ", "3G Mobile"),
        APPLE_AAC_AUDIO("M4P ", "Apple Audio"),
        AES_ENCRYPTED_AUDIO("M4B ", "Apple encrypted Audio"),
        APPLE_AUDIO("mp71", "Apple Audio"),
        ISO14496_12_MPEG7_METADATA("mp71", "MAIN_SYNTHESIS"),
        APPLE_AUDIO_ONLY("M4A ", "M4A Audio");

        private String id;
        private String description;

        private Brand(String id, String description) {
            this.id = id;
            this.description = description;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

