/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser.token;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.server.impl.browser.token.SimpleTokenHandler;
import org.apache.chemistry.opencmis.server.impl.browser.token.SimpleTokenHandlerSessionHelper;
import org.apache.chemistry.opencmis.server.impl.browser.token.TokenHandler;
import org.apache.chemistry.opencmis.server.shared.BasicAuthCallContextHandler;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenCallContextHandler
extends BasicAuthCallContextHandler
implements TokenHandler {
    private static final long serialVersionUID = 1L;
    private final TokenHandler tokenHandler = new SimpleTokenHandler();

    @Override
    public Map<String, String> getCallContextMap(HttpServletRequest request) {
        boolean isLastResultRequest;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> basicAuthMap = super.getCallContextMap(request);
        if (basicAuthMap != null && !basicAuthMap.isEmpty()) {
            result.putAll(basicAuthMap);
        }
        if (!(isLastResultRequest = "lastresult".equalsIgnoreCase(HttpUtils.getStringParameter(request, "cmisselector")))) {
            if (request.getParameter("token") != null) {
                if (SimpleTokenHandlerSessionHelper.testAndInvalidateToken(request)) {
                    String token = SimpleTokenHandlerSessionHelper.getToken(request);
                    String appId = SimpleTokenHandlerSessionHelper.getApplicationIdFromKey(token);
                    result.put("username", SimpleTokenHandlerSessionHelper.getUser(request, appId));
                    result.put("password", null);
                } else {
                    throw new CmisPermissionDeniedException("Invalid token!");
                }
            }
            if (!result.containsKey("username")) {
                throw new CmisPermissionDeniedException("No authentication!");
            }
        }
        return result;
    }

    @Override
    public void service(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.tokenHandler.service(servletContext, request, response);
    }
}

