/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionParameterMap
extends LinkedHashMap<String, String> {
    private static final long serialVersionUID = 1L;

    public SessionParameterMap() {
    }

    public SessionParameterMap(Map<? extends String, ? extends String> map) {
        super(map);
    }

    @Override
    public String put(String key, long value) {
        return this.put(key, Long.toString(value));
    }

    @Override
    public String put(String key, boolean value) {
        return this.put(key, value ? "true" : "false");
    }

    public void setAtomPubBindingUrl(String url) {
        if (url == null) {
            this.remove("org.apache.chemistry.opencmis.binding.spi.type");
            this.remove("org.apache.chemistry.opencmis.binding.atompub.url");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            this.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        }
    }

    public void setWebServicesBindingUrl(String url) {
        if (url == null) {
            this.remove("org.apache.chemistry.opencmis.binding.spi.type");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.RepositoryService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.NavigationService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.ObjectService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.VersioningService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.RelationshipService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.ACLService");
            this.remove("org.apache.chemistry.opencmis.binding.webservices.PolicyService");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            this.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url);
            this.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url);
        }
    }

    public void setWebServicesMemoryThreshold(long threshold) {
        this.put("org.apache.chemistry.opencmis.binding.webservices.memoryThreshold", threshold);
    }

    public void setBrowserBindingUrl(String url) {
        if (url == null) {
            this.remove("org.apache.chemistry.opencmis.binding.spi.type");
            this.remove("org.apache.chemistry.opencmis.binding.browser.url");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.BROWSER.value());
            this.put("org.apache.chemistry.opencmis.binding.browser.url", url);
        }
    }

    public void setBrowserBindingSuccinct(boolean succinct) {
        this.put("org.apache.chemistry.opencmis.binding.browser.succinct", succinct);
    }

    public void setLocalBindingClass(Class<? extends SessionFactory> serviceFactoryClass) {
        if (serviceFactoryClass == null) {
            this.remove("org.apache.chemistry.opencmis.binding.spi.type");
            this.remove("org.apache.chemistry.opencmis.binding.local.classname");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.LOCAL.value());
            this.put("org.apache.chemistry.opencmis.binding.local.classname", serviceFactoryClass.getName());
        }
    }

    public void setRepositoryId(String repositoryId) {
        if (repositoryId == null) {
            this.remove("org.apache.chemistry.opencmis.session.repository.id");
        } else {
            this.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        }
    }

    public void setUserAndPassword(String user, String password) {
        if (user == null) {
            this.remove("org.apache.chemistry.opencmis.user");
            this.remove("org.apache.chemistry.opencmis.password");
        } else {
            this.put("org.apache.chemistry.opencmis.user", user);
            this.put("org.apache.chemistry.opencmis.password", password);
        }
    }

    public void setBearerToken(String token) {
        if (token == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.accessToken");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.accessToken", token);
        }
    }

    public void setNoAuthentication() {
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
        this.remove("org.apache.chemistry.opencmis.binding.auth.classname");
    }

    public void setBasicAuthentication(String user, String password) {
        if (user == null) {
            throw new IllegalArgumentException("User must be set!");
        }
        this.setUserAndPassword(user, password);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", true);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
        this.remove("org.apache.chemistry.opencmis.binding.auth.classname");
    }

    public void setUsernameTokenAuthentication(String user, String password, boolean basicAuth) {
        if (user == null) {
            throw new IllegalArgumentException("User must be set!");
        }
        this.setUserAndPassword(user, password);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", true);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", basicAuth);
        this.remove("org.apache.chemistry.opencmis.binding.auth.classname");
    }

    public void setNtlmAuthentication(String user, String password) {
        if (user == null) {
            throw new IllegalArgumentException("User must be set!");
        }
        this.setUserAndPassword(user, password);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.classname", "org.apache.chemistry.opencmis.client.bindings.spi.NTLMAuthenticationProvider");
    }

    public void setOAuthBearerTokenAuthentication(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token must be set!");
        }
        this.setBearerToken(token);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.oauth.bearer", true);
        this.put("org.apache.chemistry.opencmis.oauth.accessToken", token);
        this.remove("org.apache.chemistry.opencmis.binding.auth.classname");
    }

    public void setOAuthAuthentication(String tokenEntpoint, String clientId, String clientSecret, String code, String redirectUri) {
        if (tokenEntpoint == null || tokenEntpoint.length() == 0) {
            throw new IllegalArgumentException("Token endpoint must be set!");
        }
        if (clientId == null || clientId.length() == 0) {
            throw new IllegalArgumentException("Client ID must be set!");
        }
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.oauth.bearer", false);
        this.put("org.apache.chemistry.opencmis.oauth.tokenEndpoint", tokenEntpoint);
        this.put("org.apache.chemistry.opencmis.oauth.clientId", clientId);
        if (clientSecret == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.clientSecret");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.clientSecret", clientSecret);
        }
        if (code == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.code");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.code", code);
        }
        if (redirectUri == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.redirectUri");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.redirectUri", redirectUri);
        }
        this.put("org.apache.chemistry.opencmis.binding.auth.classname", "org.apache.chemistry.opencmis.client.bindings.spi.OAuthAuthenticationProvider");
    }

    public void setOAuthAuthentication(String tokenEntpoint, String clientId, String clientSecret, String accessToken, String refreshToken, long expirationTimestamp) {
        if (tokenEntpoint == null || tokenEntpoint.length() == 0) {
            throw new IllegalArgumentException("Token endpoint must be set!");
        }
        if (clientId == null || clientId.length() == 0) {
            throw new IllegalArgumentException("Client ID must be set!");
        }
        this.put("org.apache.chemistry.opencmis.binding.auth.http.basic", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
        this.put("org.apache.chemistry.opencmis.binding.auth.http.oauth.bearer", false);
        this.put("org.apache.chemistry.opencmis.oauth.tokenEndpoint", tokenEntpoint);
        this.put("org.apache.chemistry.opencmis.oauth.clientId", clientId);
        if (clientSecret == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.clientSecret");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.clientSecret", clientSecret);
        }
        if (accessToken == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.accessToken");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.accessToken", accessToken);
        }
        if (refreshToken == null) {
            this.remove("org.apache.chemistry.opencmis.oauth.refreshToken");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.refreshToken", refreshToken);
        }
        if (expirationTimestamp < 0L) {
            this.remove("org.apache.chemistry.opencmis.oauth.expirationTimestamp");
        } else {
            this.put("org.apache.chemistry.opencmis.oauth.expirationTimestamp", expirationTimestamp);
        }
        this.put("org.apache.chemistry.opencmis.binding.auth.classname", "org.apache.chemistry.opencmis.client.bindings.spi.OAuthAuthenticationProvider");
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            this.remove("org.apache.chemistry.opencmis.locale.iso639");
            this.remove("org.apache.chemistry.opencmis.locale.iso3166");
            this.remove("org.apache.chemistry.opencmis.locale.variant");
        } else {
            if (locale.getLanguage().length() == 0) {
                this.remove("org.apache.chemistry.opencmis.locale.iso639");
            } else {
                this.put("org.apache.chemistry.opencmis.locale.iso639", locale.getLanguage());
            }
            if (locale.getCountry().length() == 0) {
                this.remove("org.apache.chemistry.opencmis.locale.iso3166");
            } else {
                this.put("org.apache.chemistry.opencmis.locale.iso3166", locale.getCountry());
            }
            if (locale.getVariant().length() == 0) {
                this.remove("org.apache.chemistry.opencmis.locale.variant");
            } else {
                this.put("org.apache.chemistry.opencmis.locale.variant", locale.getVariant());
            }
        }
    }

    public void setLocale(String language, String country) {
        this.setLocale(new Locale(language, country));
    }

    public void setLocale(String language) {
        this.setLocale(new Locale(language));
    }

    public void setCookies(boolean cookies) {
        this.put("org.apache.chemistry.opencmis.binding.cookies", cookies);
    }

    public void setCompression(boolean compression) {
        this.put("org.apache.chemistry.opencmis.binding.compression", compression);
    }

    public void setClientCompression(boolean compression) {
        this.put("org.apache.chemistry.opencmis.binding.clientcompression", compression);
    }

    public void setConnectionTimeout(long timeout) {
        this.put("org.apache.chemistry.opencmis.binding.connecttimeout", timeout);
    }

    public void setReadTimeout(long timeout) {
        this.put("org.apache.chemistry.opencmis.binding.readtimeout", timeout);
    }

    public void setHttpInvoker(Class<?> httpInvokerClass) {
        if (httpInvokerClass == null) {
            this.remove("org.apache.chemistry.opencmis.binding.httpinvoker.classname");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", httpInvokerClass.getName());
        }
    }

    public void addHeader(String header, String value) {
        if (header == null || header.trim().length() == 0) {
            return;
        }
        int x = 0;
        while (this.containsKey("org.apache.chemistry.opencmis.binding.header." + x)) {
            ++x;
        }
        this.put("org.apache.chemistry.opencmis.binding.header." + x, header + ":" + value);
    }

    public void setProxyUserAndPassword(String user, String password) {
        if (user == null) {
            this.remove("org.apache.chemistry.opencmis.binding.proxyuser");
            this.remove("org.apache.chemistry.opencmis.binding.proxypassword");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.proxyuser", user);
            this.put("org.apache.chemistry.opencmis.binding.proxypassword", password);
        }
    }

    public void setAuthenticationProvider(Class<? extends AuthenticationProvider> authenticationProviderClass) {
        if (authenticationProviderClass == null) {
            this.remove("org.apache.chemistry.opencmis.binding.auth.classname");
        } else {
            this.put("org.apache.chemistry.opencmis.binding.auth.classname", authenticationProviderClass.getName());
        }
    }

    public void setObjectFactory(Class<? extends ObjectFactory> objectFactoryClass) {
        if (objectFactoryClass == null) {
            this.remove("org.apache.chemistry.opencmis.objectfactory.classname");
        } else {
            this.put("org.apache.chemistry.opencmis.objectfactory.classname", objectFactoryClass.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must be set!");
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            this.load(stream);
        }
        finally {
            stream.close();
        }
    }

    public void load(InputStream stream) throws IOException {
        String line;
        if (stream == null) {
            throw new IllegalArgumentException("Stream must be set!");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF8"));
        while ((line = reader.readLine()) != null) {
            this.putLine(line);
        }
    }

    public void parse(String parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters string must be set!");
        }
        for (String line : parameters.split("\n")) {
            this.putLine(line);
        }
    }

    protected void putLine(String line) {
        assert (line != null);
        String lineTrim = line.trim();
        if (lineTrim.length() == 0 || lineTrim.charAt(0) == '#') {
            return;
        }
        int sep = lineTrim.indexOf(61);
        if (sep == -1) {
            sep = lineTrim.indexOf(58);
        }
        if (sep == -1) {
            this.put(lineTrim, null);
        } else {
            this.put(lineTrim.substring(0, sep).trim(), lineTrim.substring(sep + 1).trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File must be set!");
        }
        FileOutputStream stream = new FileOutputStream(file);
        try {
            this.store(stream);
        }
        finally {
            stream.close();
        }
    }

    public void store(OutputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream must be set!");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = (String)this.get(key);
            if (value == null) {
                value = "";
            }
            writer.write(key);
            writer.write(61);
            writer.write(value);
            writer.newLine();
        }
        writer.flush();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append((String)entry.getValue());
            sb.append('\n');
        }
        return sb.toString();
    }
}

