/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating;

import java.io.Serializable;
import java.security.Principal;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.rating.api.LikeService;
import org.nuxeo.runtime.api.Framework;

@Name(value="likeActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class LikeActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;

    public boolean hasUserLiked(Principal principal, DocumentModel doc) {
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        return likeService.hasUserLiked(principal.getName(), doc);
    }

    public void like(Principal principal, DocumentModel doc) {
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        likeService.like(principal.getName(), doc);
        this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, "label.document.liked", new Object[0]);
    }

    public void cancelLike(Principal principal, DocumentModel doc) {
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        likeService.cancel(principal.getName(), doc);
        this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, "label.document.unliked", new Object[0]);
    }

    public long getLikesCount(DocumentModel doc) {
        LikeService likeService = (LikeService)Framework.getLocalService(LikeService.class);
        return likeService.getLikesCount(doc);
    }
}

