/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class MultiFilingService {

    public static class RemoveObjectFromFolder
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String folderId = this.getStringParameter(request, "folderId");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            Holder objectIdHolder = new Holder((Object)objectId);
            service.removeObjectFromFolder(repositoryId, objectId, folderId, null);
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, newObjectId));
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class AddObjectToFolder
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String folderId = this.getStringParameter(request, "folderId");
            Boolean allVersions = this.getBooleanParameter(request, "allVersions");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            Holder objectIdHolder = new Holder((Object)objectId);
            service.addObjectToFolder(repositoryId, objectId, folderId, allVersions, null);
            String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
            ObjectData object = this.getSimpleObject(service, repositoryId, newObjectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            this.setStatus(request, response, 201);
            response.setHeader("Location", this.compileObjectLocationUrl(request, repositoryId, newObjectId));
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }
}

