/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.CallContextImpl;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.impl.atompub.ServiceDocument;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public class RepositoryService {

    public static class DeleteType
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "id");
            service.deleteType(repositoryId, typeId, null);
            response.setStatus(204);
        }
    }

    public static class UpdateType
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            ThresholdOutputStreamFactory streamFactory = (ThresholdOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.parse((InputStream)request.getInputStream());
            TypeDefinition newType = service.updateType(repositoryId, parser.getTypeDefinition(), null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Location", this.compileUrl(baseUrl, "type", newType.getId()));
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeTypeEntry(entry, newType, null, repositoryId, this.compileBaseUrl(request, repositoryId), true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class CreateType
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            ThresholdOutputStreamFactory streamFactory = (ThresholdOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.parse((InputStream)request.getInputStream());
            TypeDefinition newType = service.createType(repositoryId, parser.getTypeDefinition(), null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Location", this.compileUrl(baseUrl, "type", newType.getId()));
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeTypeEntry(entry, newType, null, repositoryId, this.compileBaseUrl(request, repositoryId), true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class GetTypeDefinition
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "id");
            TypeDefinition type = service.getTypeDefinition(repositoryId, typeId, null);
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=entry");
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeTypeEntry(entry, type, null, repositoryId, this.compileBaseUrl(request, repositoryId), true, context.getCmisVersion());
            entry.endDocument();
        }
    }

    public static class GetTypeDescendants
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "typeId");
            BigInteger depth = this.getBigIntegerParameter(request, "depth");
            boolean includePropertyDefinitions = this.getBooleanParameter(request, "includePropertyDefinitions", false);
            List typeTree = service.getTypeDescendants(repositoryId, typeId, depth, Boolean.valueOf(includePropertyDefinitions), null);
            String parentTypeId = null;
            String typeName = "Type Children";
            if (typeId != null) {
                TypeDefinition typeDefinition = service.getTypeDefinition(repositoryId, typeId, null);
                parentTypeId = typeDefinition == null ? null : typeDefinition.getParentTypeId();
                typeName = typeDefinition == null ? typeId : typeDefinition.getDisplayName();
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(typeId, null, "unknown", typeName, new GregorianCalendar(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "typedesc", null);
            selfLink.addParameter("typeId", (Object)typeId);
            selfLink.addParameter("depth", (Object)depth);
            selfLink.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
            feed.writeSelfLink(selfLink.toString(), typeId);
            feed.writeViaLink(this.compileUrl(baseUrl, "type", typeId));
            UrlBuilder downLink = this.compileUrlBuilder(baseUrl, "types", null);
            downLink.addParameter("typeId", (Object)typeId);
            feed.writeDownLink(downLink.toString(), "application/atom+xml;type=feed");
            if (parentTypeId != null) {
                feed.writeUpLink(this.compileUrl(baseUrl, "type", parentTypeId), "application/atom+xml;type=entry");
            }
            if (typeTree != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                for (TypeDefinitionContainer container : typeTree) {
                    if (container == null || container.getTypeDefinition() == null) continue;
                    this.writeTypeEntry(entry, container.getTypeDefinition(), container.getChildren(), repositoryId, baseUrl, false, context.getCmisVersion());
                }
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class GetTypeChildren
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String typeId = this.getStringParameter(request, "typeId");
            boolean includePropertyDefinitions = this.getBooleanParameter(request, "includePropertyDefinitions", false);
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            BigInteger skipCount = this.getBigIntegerParameter(request, "skipCount");
            TypeDefinitionList typeList = service.getTypeChildren(repositoryId, typeId, Boolean.valueOf(includePropertyDefinitions), maxItems, skipCount, null);
            BigInteger numItems = typeList == null ? null : typeList.getNumItems();
            Boolean hasMoreItems = typeList == null ? null : typeList.hasMoreItems();
            String parentTypeId = null;
            String typeName = "Type Children";
            if (typeId != null) {
                TypeDefinition typeDefinition = service.getTypeDefinition(repositoryId, typeId, null);
                parentTypeId = typeDefinition == null ? null : typeDefinition.getParentTypeId();
                typeName = typeDefinition == null ? typeId : typeDefinition.getDisplayName();
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(typeId, null, "unknown", typeName, new GregorianCalendar(), null, numItems);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "types", null);
            selfLink.addParameter("typeId", (Object)typeId);
            selfLink.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
            selfLink.addParameter("maxItems", (Object)maxItems);
            selfLink.addParameter("skipCount", (Object)skipCount);
            feed.writeSelfLink(selfLink.toString(), typeId);
            feed.writeViaLink(this.compileUrl(baseUrl, "type", typeId));
            UrlBuilder downLink = this.compileUrlBuilder(baseUrl, "typedesc", null);
            downLink.addParameter("typeId", (Object)typeId);
            feed.writeDownLink(downLink.toString(), "application/cmistree+xml");
            if (parentTypeId != null) {
                feed.writeUpLink(this.compileUrl(baseUrl, "type", parentTypeId), "application/atom+xml;type=entry");
            }
            UrlBuilder pagingUrl = this.compileUrlBuilder(baseUrl, "types", null);
            pagingUrl.addParameter("typeId", (Object)typeId);
            pagingUrl.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
            feed.writePagingLinks(pagingUrl, maxItems, skipCount, numItems, hasMoreItems, PAGE_SIZE);
            UrlBuilder collectionUrl = this.compileUrlBuilder(baseUrl, "types", null);
            collectionUrl.addParameter("typeId", (Object)typeId);
            feed.writeCollection(collectionUrl.toString(), null, "Types Collection", "");
            if (typeList != null && typeList.getList() != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                for (TypeDefinition type : typeList.getList()) {
                    this.writeTypeEntry(entry, type, null, repositoryId, baseUrl, false, context.getCmisVersion());
                }
            }
            feed.writeExtensions((ExtensionsData)typeList);
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class GetRepositories
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            repositoryId = this.getStringParameter(request, "repositoryId");
            List<RepositoryInfo> infoDataList = null;
            if (repositoryId == null) {
                infoDataList = service.getRepositoryInfos(null);
            } else {
                infoDataList = Collections.singletonList(service.getRepositoryInfo(repositoryId, null));
                if (context instanceof CallContextImpl) {
                    ((CallContextImpl)context).put("repositoryId", repositoryId);
                }
            }
            response.setStatus(200);
            response.setContentType("application/atomsvc+xml");
            ServiceDocument serviceDoc = new ServiceDocument();
            serviceDoc.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            serviceDoc.startServiceDocument();
            if (infoDataList != null) {
                CmisVersion cmisVersion = context.getCmisVersion();
                for (RepositoryInfo infoData : infoDataList) {
                    if (infoData == null) continue;
                    String repId = infoData.getId();
                    UrlBuilder baseUrl = this.compileBaseUrl(request, repId);
                    boolean supportsQuery = false;
                    boolean supportsUnFiling = false;
                    boolean supportsMultifiling = false;
                    boolean supportsFolderTree = false;
                    boolean supportsRootDescendants = false;
                    boolean supportsChanges = false;
                    if (infoData.getCapabilities() != null) {
                        RepositoryCapabilities cap = infoData.getCapabilities();
                        if (cap.getQueryCapability() != null) {
                            boolean bl = supportsQuery = cap.getQueryCapability() != CapabilityQuery.NONE;
                        }
                        if (cap.isUnfilingSupported() != null) {
                            supportsUnFiling = cap.isUnfilingSupported();
                        }
                        if (cap.isMultifilingSupported() != null) {
                            supportsMultifiling = cap.isMultifilingSupported();
                        }
                        if (cap.isGetFolderTreeSupported() != null) {
                            supportsFolderTree = cap.isGetFolderTreeSupported();
                        }
                        if (cap.isGetDescendantsSupported() != null) {
                            supportsRootDescendants = cap.isGetDescendantsSupported();
                        }
                        if (cap.getChangesCapability() != null) {
                            supportsChanges = cap.getChangesCapability() != CapabilityChanges.NONE;
                        }
                    }
                    serviceDoc.startWorkspace(infoData.getId());
                    serviceDoc.writeCollection(this.compileUrl(baseUrl, "children", infoData.getRootFolderId()), "root", "Root Collection", "application/atom+xml;type=entry", "application/cmisatom+xml");
                    serviceDoc.writeCollection(this.compileUrl(baseUrl, "types", null), "types", "Types Collection", "");
                    if (supportsQuery) {
                        serviceDoc.writeCollection(this.compileUrl(baseUrl, "query", null), "query", "Query Collection", "application/cmisquery+xml");
                    }
                    serviceDoc.writeCollection(this.compileUrl(baseUrl, "checkedout", null), "checkedout", "Checked Out Collection", "application/cmisatom+xml");
                    if (supportsUnFiling || supportsMultifiling) {
                        serviceDoc.writeCollection(this.compileUrl(baseUrl, "unfiled", null), "unfiled", "Unfiled Collection", "application/cmisatom+xml");
                    }
                    serviceDoc.writeCollection(this.compileUrl(baseUrl, "update", null), "update", "Bulk Update Collection", "application/cmisatom+xml");
                    serviceDoc.writeRepositoryInfo(infoData, cmisVersion);
                    serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/typedescendants", this.compileUrl(baseUrl, "typedesc", null), "application/atom+xml;type=feed", null);
                    if (supportsFolderTree) {
                        serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", this.compileUrl(baseUrl, "foldertree", infoData.getRootFolderId()), "application/cmistree+xml", null);
                    }
                    if (supportsRootDescendants) {
                        serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/rootdescendants", this.compileUrl(baseUrl, "descendants", infoData.getRootFolderId()), "application/cmistree+xml", infoData.getRootFolderId());
                    }
                    if (supportsChanges) {
                        serviceDoc.writeLink("http://docs.oasis-open.org/ns/cmis/link/200908/changes", this.compileUrl(baseUrl, "changes", null), "application/atom+xml;type=feed", null);
                    }
                    String url = this.compileUrl(baseUrl, "id", null) + "?id={id}&filter={filter}&includeAllowableActions={includeAllowableActions}" + "&includeACL={includeACL}&includePolicyIds={includePolicyIds}" + "&includeRelationships={includeRelationships}&renditionFilter={renditionFilter}";
                    serviceDoc.writeUriTemplate(url, "objectbyid", "application/atom+xml;type=entry");
                    url = this.compileUrl(baseUrl, "path", null) + "?path={path}&filter={filter}&includeAllowableActions={includeAllowableActions}" + "&includeACL={includeACL}&includePolicyIds={includePolicyIds}" + "&includeRelationships={includeRelationships}&renditionFilter={renditionFilter}";
                    serviceDoc.writeUriTemplate(url, "objectbypath", "application/atom+xml;type=entry");
                    url = this.compileUrl(baseUrl, "type", null) + "?id={id}";
                    serviceDoc.writeUriTemplate(url, "typebyid", "application/atom+xml;type=entry");
                    if (supportsQuery) {
                        url = this.compileUrl(baseUrl, "query", null) + "?q={q}&searchAllVersions={searchAllVersions}&includeAllowableActions={includeAllowableActions}" + "&includeRelationships={includeRelationships}&maxItems={maxItems}&skipCount={skipCount}";
                        serviceDoc.writeUriTemplate(url, "query", "application/atom+xml;type=feed");
                    }
                    serviceDoc.endWorkspace();
                }
            }
            serviceDoc.endServiceDocument();
            serviceDoc.endDocument();
        }
    }
}

