/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.activity.ActivityUpgrader;
import org.nuxeo.ecm.activity.ActivityUpgraderDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class ActivityUpgraderRegistry
extends ContributionFragmentRegistry<ActivityUpgraderDescriptor> {
    protected Map<String, ActivityUpgrader> activityUpgraders = new HashMap<String, ActivityUpgrader>();

    public List<ActivityUpgrader> getOrderedActivityUpgraders() {
        ArrayList<ActivityUpgrader> upgraders = new ArrayList<ActivityUpgrader>(this.activityUpgraders.values());
        Collections.sort(upgraders, new Comparator<ActivityUpgrader>(){

            @Override
            public int compare(ActivityUpgrader o1, ActivityUpgrader o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
        return upgraders;
    }

    public String getContributionId(ActivityUpgraderDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ActivityUpgraderDescriptor contrib, ActivityUpgraderDescriptor newOrigContrib) {
        this.activityUpgraders.put(id, contrib.getActivityUpgrader());
    }

    public void contributionRemoved(String id, ActivityUpgraderDescriptor origContrib) {
        this.activityUpgraders.remove(id);
    }

    public ActivityUpgraderDescriptor clone(ActivityUpgraderDescriptor orig) {
        return orig.clone();
    }

    public void merge(ActivityUpgraderDescriptor src, ActivityUpgraderDescriptor dst) {
        Class<? extends ActivityUpgrader> clazz = src.getActivityUpgraderClass();
        if (clazz != null) {
            dst.setActivityUpgraderClass(clazz);
        }
        dst.setOrder(src.getOrder());
        boolean enabled = src.isEnabled();
        if (enabled != dst.isEnabled()) {
            dst.setEnabled(enabled);
        }
    }
}

