/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.rating;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.rating.LikesCountActivityStreamFilter;
import org.nuxeo.ecm.rating.api.LikeService;
import org.nuxeo.ecm.rating.api.LikeStatus;
import org.nuxeo.ecm.rating.api.RatingService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class LikeServiceImpl
extends DefaultComponent
implements LikeService {
    public static final int LIKE_RATING = 1;
    public static final int DISLIKE_RATING = -1;

    public void like(String username, String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        ratingService.cancelRate(username, activityObject, "like");
        ratingService.rate(username, 1, activityObject, "like");
    }

    public void like(String username, DocumentModel doc) {
        this.like(username, ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public boolean hasUserLiked(String username, String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        double average = ratingService.getAverageRatingForUser(username, activityObject, "like");
        return average > 0.0;
    }

    public boolean hasUserLiked(String username, DocumentModel doc) {
        return this.hasUserLiked(username, ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public long getLikesCount(String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        return ratingService.getRatesCount(activityObject, 1, "like");
    }

    public long getLikesCount(DocumentModel doc) {
        return this.getLikesCount(ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public void dislike(String username, String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        ratingService.cancelRate(username, activityObject, "like");
        ratingService.rate(username, -1, activityObject, "like");
    }

    public void dislike(String username, DocumentModel doc) {
        this.dislike(username, ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public boolean hasUserDisliked(String username, String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        double average = ratingService.getAverageRatingForUser(username, activityObject, "like");
        return average < 0.0;
    }

    public boolean hasUserDisliked(String username, DocumentModel doc) {
        return this.hasUserDisliked(username, ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public long getDislikesCount(String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        return ratingService.getRatesCount(activityObject, -1, "like");
    }

    public long getDislikesCount(DocumentModel doc) {
        return this.getDislikesCount(ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public void cancel(String username, String activityObject) {
        RatingService ratingService = (RatingService)Framework.getLocalService(RatingService.class);
        ratingService.cancelRate(username, activityObject, "like");
    }

    public void cancel(String username, DocumentModel doc) {
        this.cancel(username, ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public LikeStatus getLikeStatus(String activityObject) {
        long likesCount = this.getLikesCount(activityObject);
        long dislikesCount = this.getDislikesCount(activityObject);
        return new LikeStatus(activityObject, likesCount, dislikesCount);
    }

    public LikeStatus getLikeStatus(DocumentModel doc) {
        return this.getLikeStatus(ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public LikeStatus getLikeStatus(String username, String activityObject) {
        long likesCount = this.getLikesCount(activityObject);
        long dislikesCount = this.getDislikesCount(activityObject);
        int userLikeStatus = this.hasUserLiked(username, activityObject) ? 1 : (this.hasUserDisliked(username, activityObject) ? -1 : 0);
        return new LikeStatus(activityObject, likesCount, dislikesCount, username, userLikeStatus);
    }

    public LikeStatus getLikeStatus(String username, DocumentModel doc) {
        return this.getLikeStatus(username, ActivityHelper.createDocumentActivityObject((DocumentModel)doc));
    }

    public ActivitiesList getMostLikedActivities(CoreSession session, int limit, DocumentModel source, Date fromDt, Date toDt) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (fromDt != null && toDt != null) {
            parameters.put("fromDt", fromDt);
            parameters.put("toDt", toDt);
        }
        parameters.put("context", ActivityHelper.createDocumentActivityObject((DocumentModel)source));
        parameters.put("object", 1);
        parameters.put("actor", ActivityHelper.createUserActivityObject((String)session.getPrincipal().getName()));
        parameters.put("queryTypeParameter", (Object)LikesCountActivityStreamFilter.QueryType.GET_DOCUMENTS_COUNT);
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        ActivitiesList documentActivitiesList = activityStreamService.query("LikesCountActivityStreamFilter", parameters);
        ActivitiesList mostLikedActivities = documentActivitiesList.filterActivities(session);
        parameters.put("queryTypeParameter", (Object)LikesCountActivityStreamFilter.QueryType.GET_MINI_MESSAGE_COUNT);
        ActivitiesList miniMessageActivitiesList = activityStreamService.query("LikesCountActivityStreamFilter", parameters, 0L, (long)limit);
        mostLikedActivities.addAll((Collection)miniMessageActivitiesList);
        Collections.sort(mostLikedActivities, new Comparator<Activity>(){

            @Override
            public int compare(Activity o1, Activity o2) {
                return o2.getObject().compareTo(o1.getObject());
            }
        });
        if (mostLikedActivities.size() > limit) {
            return new ActivitiesListImpl((Collection)mostLikedActivities.subList(0, limit));
        }
        return mostLikedActivities;
    }

    public ActivitiesList getMostLikedActivities(CoreSession session, int limit, DocumentModel source) {
        return this.getMostLikedActivities(session, limit, source, null, null);
    }
}

