/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.provider;

import java.util.Collection;
import java.util.List;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.PermissionFilter;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class ImportFolderPageProvider
extends CoreQueryDocumentPageProvider {
    public static final Filter WRITE_PERMISSION_FILTER = new PermissionFilter("Write", true);
    public static final Filter ASSET_SUB_TYPE_FILTER = new AssetSubTypeFilter();
    public static final Filter COMPOUND_FILTER = new CompoundFilter(new Filter[]{WRITE_PERMISSION_FILTER, ASSET_SUB_TYPE_FILTER});

    protected Filter getFilter() {
        return COMPOUND_FILTER;
    }

    protected static class AssetSubTypeFilter
    implements Filter {
        protected AssetSubTypeFilter() {
        }

        public boolean accept(DocumentModel doc) {
            TypeManager typeManager = (TypeManager)Framework.getLocalService(TypeManager.class);
            DamService damService = (DamService)Framework.getLocalService(DamService.class);
            List<Type> allowedAssetTypes = damService.getAllowedAssetTypes();
            Collection allowedSubTypes = typeManager.getAllowedSubTypes(doc.getType(), doc);
            for (Type type : allowedAssetTypes) {
                if (!allowedSubTypes.contains(type)) continue;
                return true;
            }
            return false;
        }
    }
}

