/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.ImageModel;
import it.tidalwave.image.java2d.ConvertToBufferedImageJ2DOp;
import it.tidalwave.image.java2d.DrawJ2DOp;
import it.tidalwave.image.java2d.ImageModelJ2D;
import it.tidalwave.image.java2d.OptimizeJ2DOp;
import it.tidalwave.image.java2d.PaintJ2DOp;
import it.tidalwave.image.java2d.RotateJ2DOp;
import it.tidalwave.image.java2d.RotateQuadrantJ2DOp;
import it.tidalwave.image.java2d.ScaleJ2DOp;
import it.tidalwave.image.java2d.WriteJ2DOp;
import it.tidalwave.image.op.ConvertToBufferedImageOp;
import it.tidalwave.image.op.DrawOp;
import it.tidalwave.image.op.ImplementationFactory;
import it.tidalwave.image.op.ImplementationFactoryRegistry;
import it.tidalwave.image.op.OptimizeOp;
import it.tidalwave.image.op.PaintOp;
import it.tidalwave.image.op.RotateOp;
import it.tidalwave.image.op.RotateQuadrantOp;
import it.tidalwave.image.op.ScaleOp;
import it.tidalwave.image.op.WriteOp;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class ImplementationFactoryJ2D
extends ImplementationFactory {
    private static final String CLASS = ImplementationFactoryJ2D.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static ImplementationFactoryJ2D instance;
    private Class planarImageClass;

    public static synchronized ImplementationFactoryJ2D getInstance() {
        if (instance == null) {
            instance = new ImplementationFactoryJ2D();
            ImplementationFactoryRegistry.getInstance().registerFactory(instance);
        }
        return instance;
    }

    public ImplementationFactoryJ2D() {
        super(BufferedImage.class);
        this.registerImplementation(ConvertToBufferedImageOp.class, ConvertToBufferedImageJ2DOp.class);
        this.registerImplementation(DrawOp.class, DrawJ2DOp.class);
        this.registerImplementation(OptimizeOp.class, OptimizeJ2DOp.class);
        this.registerImplementation(PaintOp.class, PaintJ2DOp.class);
        this.registerImplementation(RotateQuadrantOp.class, RotateQuadrantJ2DOp.class);
        this.registerImplementation(RotateOp.class, RotateJ2DOp.class);
        this.registerImplementation(ScaleOp.class, ScaleJ2DOp.class);
        this.registerImplementation(WriteOp.class, WriteJ2DOp.class);
        try {
            this.planarImageClass = Class.forName("javax.media.jai.PlanarImage");
        }
        catch (Throwable e) {
            logger.warning("JAI not available: " + e);
        }
        try {
            Class<?> clazz = Class.forName("it.tidalwave.image.java2d.AdditionalOperations");
            Method method = clazz.getMethod("register", ImplementationFactoryJ2D.class);
            method.invoke(null, this);
        }
        catch (Throwable e) {
            logger.warning("Additional Java2D operations not available: " + e);
        }
    }

    public ImageModel createImageModel(BufferedImage bufferedImage) {
        return new ImageModelJ2D(bufferedImage);
    }

    public boolean canConvertFrom(Class imageClass) {
        return this.planarImageClass != null && this.planarImageClass.isAssignableFrom(imageClass);
    }

    public ImageModel convertFrom(Object image) {
        if (this.planarImageClass != null && this.planarImageClass.isAssignableFrom(image.getClass())) {
            try {
                Method method = this.planarImageClass.getMethod("getAsBufferedImage", new Class[0]);
                Object bufferedImage = method.invoke(image, new Object[0]);
                return new ImageModelJ2D(bufferedImage);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new UnsupportedOperationException("convertFrom " + image.getClass());
    }

    public boolean canConvertTo(Class imageClass) {
        return this.planarImageClass != null && this.planarImageClass.isAssignableFrom(imageClass);
    }

    public Object convertTo(Object image) {
        if (image.getClass().getName().equals("javax.media.jai.PlanarImage")) {
            return image;
        }
        throw new UnsupportedOperationException("convertTo " + image.getClass());
    }
}

