/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.metadata;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import it.tidalwave.image.metadata.EXIFDirectory;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class WorkaroundBM25 {
    private static final String CLASS = WorkaroundBM25.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    public WorkaroundBM25() {
        JpegMetadataReader.class.getName();
    }

    public void loadEXIFFromJPEGFile(ImageReader reader, EXIFDirectory exifDirectory) throws IOException, JpegProcessingException {
        logger.warning("Workaround for bug BM-25");
        final ImageInputStream iis = (ImageInputStream)reader.getInput();
        long pos = iis.getStreamPosition();
        iis.seek(0L);
        InputStream is = new InputStream(){

            public int available() throws IOException {
                long l = iis.length();
                if (l < 0L) {
                    l = 102400L;
                }
                return (int)l;
            }

            public int read() throws IOException {
                return iis.read();
            }
        };
        Metadata metadata = JpegMetadataReader.readMetadata((InputStream)is);
        exifDirectory.load(metadata.getDirectory(ExifDirectory.class));
        logger.fine(">>>> EXIF metadata: " + exifDirectory);
        is.close();
        iis.seek(pos);
    }
}

