/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.storyboard;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

public class StoryboardItem {
    public static final Log log = LogFactory.getLog(StoryboardItem.class);
    protected final DocumentModel doc;
    protected final int position;
    protected final String blobPropertyName;
    protected final String filename;
    protected String timecode = "0";

    public StoryboardItem(DocumentModel doc, String basePropertyPath, int position) {
        this.doc = doc;
        this.position = position;
        String propertyPath = basePropertyPath + "/" + position;
        this.blobPropertyName = propertyPath + "/content";
        this.filename = String.format("storyboard-%03d.jpeg", position);
        try {
            Double tc = (Double)doc.getProperty(propertyPath + "/timecode").getValue(Double.class);
            if (tc != null) {
                this.timecode = String.format("%f", Math.floor(tc));
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    public String getUrl() {
        return DocumentModelFunctions.bigFileUrl((DocumentModel)this.doc, (String)this.blobPropertyName, (String)this.filename);
    }

    public String getTimecode() {
        return this.timecode;
    }
}

