/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

public class RotationPictureConverter
implements Converter {
    private static final Log log = LogFactory.getLog(RotationPictureConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            ImagingService service = (ImagingService)Framework.getService(ImagingService.class);
            ArrayList<Blob> results = new ArrayList<Blob>();
            List sources = blobHolder.getBlobs();
            int angle = (Integer)parameters.get("angle");
            for (Blob source : sources) {
                Blob result;
                if (source == null || (result = service.rotate(source, angle)) == null) continue;
                results.add(result);
            }
            return new SimpleCachableBlobHolder(results);
        }
        catch (Exception e) {
            throw new ConversionException("Rotation conversion has failed", e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

