/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.listener;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureChangedListener
implements EventListener {
    public static final String EMPTY_PICTURE_PATH = "nuxeo.war/img/empty_picture.png";
    private static final Log log = LogFactory.getLog(PictureChangedListener.class);
    private static ImageInfo emptyPictureImageInfo;

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (doc.hasFacet("Picture") && !doc.isProxy()) {
            Property viewsProp;
            Property fileProp = doc.getProperty("file:content");
            if (!(!"documentCreated".equals(event.getName()) && !fileProp.isDirty() || (viewsProp = doc.getProperty("picture:views")) != null && viewsProp.isDirty())) {
                this.preFillPictureViews(docCtx.getCoreSession(), doc);
                Event trigger = docCtx.newEvent("updatePictureView");
                EventService eventService = (EventService)Framework.getLocalService(EventService.class);
                eventService.fireEvent(trigger);
            }
        }
    }

    protected void preFillPictureViews(CoreSession session, DocumentModel doc) {
        try {
            URL fileUrl = Thread.currentThread().getContextClassLoader().getResource(this.getEmptyPicturePath());
            if (fileUrl == null) {
                return;
            }
            FileBlob blob = new FileBlob(FileUtils.getFileFromURL((URL)fileUrl));
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            String mimeType = mimetypeRegistry.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), (Blob)blob, null);
            blob.setMimeType(mimeType);
            DocumentModel parentDoc = this.getParentDocument(session, doc);
            ArrayList pictureConversions = null;
            if (parentDoc != null && "PictureBook".equals(parentDoc.getType()) && (pictureConversions = (ArrayList)parentDoc.getPropertyValue("picturebook:picturetemplates")).isEmpty()) {
                pictureConversions = null;
            }
            if (emptyPictureImageInfo == null) {
                ImagingService imagingService = (ImagingService)Framework.getLocalService(ImagingService.class);
                emptyPictureImageInfo = imagingService.getImageInfo((Blob)blob);
            }
            PictureResourceAdapter adapter = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            adapter.preFillPictureViews((Blob)blob, (List)pictureConversions, emptyPictureImageInfo);
        }
        catch (IOException | ClientException e) {
            log.error((Object)("Error while pre-filling picture views: " + e.getMessage()), e);
        }
    }

    protected String getEmptyPicturePath() {
        return EMPTY_PICTURE_PATH;
    }

    protected DocumentModel getParentDocument(CoreSession session, DocumentModel doc) throws ClientException {
        DocumentModel parent;
        if (session.exists(doc.getRef())) {
            parent = session.getParentDocument(doc.getRef());
        } else {
            Path parentPath = doc.getPath().removeLastSegments(1);
            parent = session.getDocument((DocumentRef)new PathRef(parentPath.toString()));
        }
        return parent;
    }
}

