/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.http.AnnotationServiceFacade;

public class AnnotationsServlet
extends HttpServlet {
    private static final String REPLACE_SOURCE = "replace_source";
    private static final String W3C_ANNOTATES = "w3c_annotates";
    private static final String DOCUMENT_URL = "document_url";
    private static final long serialVersionUID = 1L;
    private AnnotationServiceFacade facade;

    public void init() throws ServletException {
        try {
            this.facade = new AnnotationServiceFacade();
        }
        catch (AnnotationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String w3c_annotates = req.getParameter(W3C_ANNOTATES);
        String annId = null;
        if (req.getPathInfo() != null) {
            annId = req.getPathInfo().replaceFirst("/", "");
        }
        resp.setContentType("application/xml");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        if (annId != null) {
            try {
                this.facade.getAnnotation(annId, (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), req.getRequestURL() + "/");
            }
            catch (AnnotationException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (w3c_annotates != null && !w3c_annotates.isEmpty()) {
            try {
                this.facade.query(w3c_annotates, (OutputStream)resp.getOutputStream(), (NuxeoPrincipal)req.getUserPrincipal());
            }
            catch (IOException | AnnotationException e) {
                throw new ServletException(e);
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        String replace_source = req.getParameter(REPLACE_SOURCE);
        if (replace_source != null) {
            ServletInputStream is = req.getInputStream();
            try {
                this.facade.updateAnnotation((InputStream)is, (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), AnnotationsServlet.getBaseUrl(req));
            }
            catch (AnnotationException e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            StringBuffer baseUrl = req.getRequestURL();
            this.facade.createAnnotation((InputStream)req.getInputStream(), (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), baseUrl.toString());
        }
        catch (AnnotationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static String getBaseUrl(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        int index = url.indexOf(req.getServletPath());
        return url.substring(0, index);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        String annId = req.getPathInfo().replaceFirst("/", "");
        String documentUrl = req.getParameter(DOCUMENT_URL);
        try {
            this.facade.deleteFor(documentUrl, annId, (NuxeoPrincipal)req.getUserPrincipal(), AnnotationsServlet.getBaseUrl(req) + "/");
        }
        catch (AnnotationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        try {
            this.facade.updateAnnotation((InputStream)req.getInputStream(), (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), req.getRequestURL() + "/");
        }
        catch (AnnotationException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

