/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.nuxeo.ecm.platform.annotations.gwt.client.AnnotationFrameApplication;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfigurationService;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfigurationServiceAsync;

public class AnnotationFrameModule
implements EntryPoint {
    private WebConfigurationServiceAsync webConfigurationService;
    private WebConfiguration webConfiguration;

    public void onModuleLoad() {
        this.waitForAnnoteaServerUrlRegistered();
    }

    private void waitForAnnoteaServerUrlRegistered() {
        Timer timer = new Timer(){

            public void run() {
                if (AnnotationFrameModule.this.isAnnoteaServerUrlRegistered()) {
                    AnnotationFrameModule.this.loadModule();
                } else {
                    this.schedule(200);
                }
            }
        };
        timer.schedule(200);
    }

    private void loadModule() {
        this.webConfigurationService = (WebConfigurationServiceAsync)GWT.create(WebConfigurationService.class);
        String url = this.getParentWindowUrl();
        this.webConfigurationService.getWebConfiguration(url, new AsyncCallback<WebConfiguration>(){

            public void onFailure(Throwable throwable) {
                Log.debug((String)("onFailure: " + throwable));
                AnnotationFrameModule.this.webConfiguration = WebConfiguration.DEFAULT_WEB_CONFIGURATION;
                AnnotationFrameModule.this.initModule();
            }

            public void onSuccess(WebConfiguration result) {
                AnnotationFrameModule.this.webConfiguration = result == null ? WebConfiguration.DEFAULT_WEB_CONFIGURATION : result;
                AnnotationFrameModule.this.initModule();
                Log.debug((String)"Module initialization finished.");
            }
        });
    }

    private native boolean isAnnoteaServerUrlRegistered();

    private native String getParentWindowUrl();

    private void initModule() {
        AnnotationFrameApplication.build(this.webConfiguration);
    }
}

