/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.annotea;

import com.google.gwt.user.client.Window;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.AnnotationDefinition;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.AnnotationUtils;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;

public class AnnotationXmlGenerator {
    private final WebConfiguration webConfiguration;
    private final Annotation annotation;
    private String annotationXml = "<?xml version=\"1.0\"?><r:RDF xmlns:a=\"http://www.w3.org/2000/10/annotation-ns#\" xmlns:r=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"    xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:h=\"http://www.w3.org/1999/xx/http#\"    xmlns:nx=\"http://www.nuxeo.org/document/uid/\">    <r:Description>      <r:type r:resource=\"http://www.w3.org/2000/10/annotation-ns#Annotation\" />      <r:type r:resource=\"${uri}\" />      <a:annotates r:resource=\"${annotates}\" />       <a:context>${context}</a:context>       <a:body r:parseType=\"Literal\">${body}</a:body>      ${fields}      ${startContainer}      ${endContainer}    </r:Description></r:RDF> ";

    public AnnotationXmlGenerator(WebConfiguration webConfiguration, Annotation annotation) {
        this.webConfiguration = webConfiguration;
        this.annotation = annotation;
    }

    public String generateXml() {
        this.replaceURI();
        this.replaceXPointer();
        this.replaceAnnotate();
        this.replaceBody();
        this.replaceFields();
        this.replaceStartContainer();
        this.replaceEndContainer();
        return this.annotationXml;
    }

    private void replaceURI() {
        AnnotationDefinition annotationDefinition = this.webConfiguration.getAnnotationDefinition(this.annotation.getShortType());
        this.annotationXml = this.annotationXml.replace("${uri}", annotationDefinition.getUri());
    }

    private void replaceXPointer() {
        XPointer xpointer = this.annotation.getXpointer();
        this.annotationXml = this.annotationXml.replace("${context}", xpointer.getXpointerString());
    }

    private void replaceAnnotate() {
        String href = Window.Location.getHref();
        this.annotationXml = href.contains("?") ? this.annotationXml.replace("${annotates}", href.substring(0, href.indexOf(63))) : this.annotationXml.replace("${annotates}", href);
    }

    private void replaceBody() {
        String encodedBody = AnnotationUtils.escapeHtml(this.annotation.getBody());
        this.annotationXml = this.annotationXml.replace("${body}", encodedBody);
    }

    private void replaceFields() {
        String fields = "";
        for (String fieldName : this.annotation.getFields().keySet()) {
            fields = fields + "<nx:" + fieldName + " r:parseType=\"Literal\">" + this.annotation.getFields().get(fieldName) + "</nx:" + fieldName + ">";
        }
        this.annotationXml = this.annotationXml.replace("${fields}", fields);
    }

    private void replaceStartContainer() {
        String replacement = "";
        if (this.annotation.hasStartContainer()) {
            replacement = "<nx:startContainer r:parseType=\"Literal\">" + this.annotation.getStartContainer().generateString() + "</nx:startContainer>";
        }
        this.annotationXml = this.annotationXml.replace("${startContainer}", replacement);
    }

    private void replaceEndContainer() {
        String replacement = "";
        if (this.annotation.hasEndContainer()) {
            replacement = "<nx:endContainer r:parseType=\"Literal\">" + this.annotation.getEndContainer().generateString() + "</nx:endContainer>";
        }
        this.annotationXml = this.annotationXml.replace("${endContainer}", replacement);
    }
}

