/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.exceptions.InvalidBoxHeaderException;
import org.jaudiotagger.audio.exceptions.NullBoxIdException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;

public class Mp4BoxHeader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.mp4.atom");
    public static final int OFFSET_POS = 0;
    public static final int IDENTIFIER_POS = 4;
    public static final int OFFSET_LENGTH = 4;
    public static final int IDENTIFIER_LENGTH = 4;
    public static final int HEADER_LENGTH = 8;
    private String id;
    protected int length;
    private long filePos;
    protected ByteBuffer dataBuffer;
    public static final String CHARSET_UTF_8 = "UTF-8";

    public Mp4BoxHeader() {
    }

    public Mp4BoxHeader(String id) {
        if (id.length() != 4) {
            throw new RuntimeException("Invalid length:atom idenifier should always be 4 characters long");
        }
        this.dataBuffer = ByteBuffer.allocate(8);
        try {
            this.id = id;
            this.dataBuffer.put(4, id.getBytes("ISO-8859-1")[0]);
            this.dataBuffer.put(5, id.getBytes("ISO-8859-1")[1]);
            this.dataBuffer.put(6, id.getBytes("ISO-8859-1")[2]);
            this.dataBuffer.put(7, id.getBytes("ISO-8859-1")[3]);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    public Mp4BoxHeader(ByteBuffer headerData) {
        this.update(headerData);
    }

    public void update(ByteBuffer headerData) {
        byte[] b = new byte[8];
        headerData.get(b);
        this.dataBuffer = ByteBuffer.wrap(b);
        this.length = Utils.getIntBE(b, 0, 3);
        this.id = Utils.getString(b, 4, 4, "ISO-8859-1");
        logger.finest("Mp4BoxHeader id:" + this.id + ":length:" + this.length);
        if (this.id.equals("\u0000\u0000\u0000\u0000")) {
            throw new NullBoxIdException(ErrorMessage.MP4_UNABLE_TO_FIND_NEXT_ATOM_BECAUSE_IDENTIFIER_IS_INVALID.getMsg(this.id));
        }
        if (this.length < 8) {
            throw new InvalidBoxHeaderException(ErrorMessage.MP4_UNABLE_TO_FIND_NEXT_ATOM_BECAUSE_IDENTIFIER_IS_INVALID.getMsg(this.id, this.length));
        }
    }

    public String getId() {
        return this.id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        byte[] headerSize = Utils.getSizeBEInt32(length);
        this.dataBuffer.put(0, headerSize[0]);
        this.dataBuffer.put(1, headerSize[1]);
        this.dataBuffer.put(2, headerSize[2]);
        this.dataBuffer.put(3, headerSize[3]);
        this.length = length;
    }

    public void setId(int length) {
        byte[] headerSize = Utils.getSizeBEInt32(length);
        this.dataBuffer.put(5, headerSize[0]);
        this.dataBuffer.put(6, headerSize[1]);
        this.dataBuffer.put(7, headerSize[2]);
        this.dataBuffer.put(8, headerSize[3]);
        this.length = length;
    }

    public ByteBuffer getHeaderData() {
        this.dataBuffer.rewind();
        return this.dataBuffer;
    }

    public int getDataLength() {
        return this.length - 8;
    }

    public String toString() {
        return "Box " + this.id + ":length" + this.length + ":filepos:" + this.filePos;
    }

    public String getEncoding() {
        return CHARSET_UTF_8;
    }

    public static Mp4BoxHeader seekWithinLevel(RandomAccessFile raf, String id) throws IOException {
        logger.finer("Started searching for:" + id + " in file at:" + raf.getChannel().position());
        Mp4BoxHeader boxHeader = new Mp4BoxHeader();
        ByteBuffer headerBuffer = ByteBuffer.allocate(8);
        int bytesRead = raf.getChannel().read(headerBuffer);
        if (bytesRead != 8) {
            return null;
        }
        headerBuffer.rewind();
        boxHeader.update(headerBuffer);
        while (!boxHeader.getId().equals(id)) {
            logger.finer("Found:" + boxHeader.getId() + " Still searching for:" + id + " in file at:" + raf.getChannel().position());
            if (boxHeader.getLength() < 8) {
                return null;
            }
            int noOfBytesSkipped = raf.skipBytes(boxHeader.getDataLength());
            logger.finer("Skipped:" + noOfBytesSkipped);
            if (noOfBytesSkipped < boxHeader.getDataLength()) {
                return null;
            }
            headerBuffer.rewind();
            bytesRead = raf.getChannel().read(headerBuffer);
            logger.finer("Header Bytes Read:" + bytesRead);
            headerBuffer.rewind();
            if (bytesRead == 8) {
                boxHeader.update(headerBuffer);
                continue;
            }
            return null;
        }
        return boxHeader;
    }

    public static Mp4BoxHeader seekWithinLevel(ByteBuffer data, String id) throws IOException {
        logger.finer("Started searching for:" + id + " in bytebuffer at" + data.position());
        Mp4BoxHeader boxHeader = new Mp4BoxHeader();
        if (data.remaining() >= 8) {
            boxHeader.update(data);
        } else {
            return null;
        }
        while (!boxHeader.getId().equals(id)) {
            logger.finer("Found:" + boxHeader.getId() + " Still searching for:" + id + " in bytebuffer at" + data.position());
            if (boxHeader.getLength() < 8) {
                return null;
            }
            if (data.remaining() < boxHeader.getLength() - 8) {
                return null;
            }
            data.position(data.position() + (boxHeader.getLength() - 8));
            if (data.remaining() >= 8) {
                boxHeader.update(data);
                continue;
            }
            return null;
        }
        logger.finer("Found:" + id + " in bytebuffer at" + data.position());
        return boxHeader;
    }

    public long getFilePos() {
        return this.filePos;
    }

    public void setFilePos(long filePos) {
        this.filePos = filePos;
    }
}

