/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.imageresource;

import java.util.Calendar;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.ImageResource;

public class DocumentImageResource
implements ImageResource {
    private static final long serialVersionUID = 1L;
    protected Blob blob;
    protected String hash;
    protected Calendar modified;
    protected DocumentModel doc;
    protected String xPath;
    protected String fileName;

    public DocumentImageResource(DocumentModel doc, String xPath) {
        this.doc = doc;
        this.xPath = xPath;
    }

    protected String getEscapedxPath(String xPath) {
        String clean = xPath.replace(":", "_");
        clean = clean.replace("/", "_");
        clean = clean.replace("[", "");
        clean = clean.replace("]", "");
        return clean;
    }

    protected void compute() throws PropertyException, ClientException {
        this.blob = (Blob)this.doc.getProperty(this.xPath).getValue();
        this.modified = (Calendar)this.doc.getProperty("dublincore", "modified");
        this.hash = this.blob.getDigest();
        if (this.hash == null) {
            this.hash = this.doc.getRepositoryName() + "_" + this.doc.getId() + "_" + this.getEscapedxPath(this.xPath);
            if (this.modified != null) {
                this.hash = this.hash + "_" + this.modified.getTimeInMillis();
            }
        }
    }

    @Override
    public Blob getBlob() throws ClientException {
        if (this.blob == null) {
            this.compute();
        }
        if (this.fileName != null) {
            this.blob.setFilename(this.fileName);
        }
        return this.blob;
    }

    @Override
    public String getHash() throws ClientException {
        if (this.hash == null) {
            this.compute();
        }
        return this.hash;
    }

    @Override
    public Calendar getModificationDate() throws ClientException {
        if (this.modified == null) {
            this.compute();
        }
        return this.modified;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }
}

