/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.user.client.Window;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfoCallback;

public class TilingInfo {
    private final String repoId;
    private final String docId;
    private final String contextPath;
    private boolean initialized;
    private int originalImageWidth;
    private int originalImageHeight;
    private double zoom;
    private int tileWidth;
    private int tileHeight;
    private int nbXTiles;
    private int nbYTiles;
    private int maxTiles;
    private long lastModificationDate;

    public TilingInfo(String repoId, String docId, String contextPath) {
        this.repoId = repoId;
        this.docId = docId;
        this.contextPath = contextPath;
    }

    public TilingInfo(String repoId, String docId, String contextPath, int tileWidth, int tileHeight, int maxTiles) {
        this(repoId, docId, contextPath);
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.maxTiles = maxTiles;
    }

    public TilingInfo(TilingInfo source) {
        this.docId = source.docId;
        this.repoId = source.repoId;
        this.contextPath = source.contextPath;
        this.originalImageWidth = source.originalImageWidth;
        this.originalImageHeight = source.originalImageHeight;
        this.zoom = source.zoom;
        this.tileWidth = source.tileWidth;
        this.tileHeight = source.tileHeight;
        this.nbXTiles = source.nbXTiles;
        this.nbYTiles = source.nbYTiles;
        this.maxTiles = source.maxTiles;
        this.initialized = source.initialized;
        this.lastModificationDate = source.lastModificationDate;
    }

    public String getRepoId() {
        return this.repoId;
    }

    public String getDocId() {
        return this.docId;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int getOriginalImageWidth() {
        return this.originalImageWidth;
    }

    public int getOriginalImageHeight() {
        return this.originalImageHeight;
    }

    public double getZoom() {
        return this.zoom;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public int getNbXTiles() {
        return this.nbXTiles;
    }

    public int getNbYTiles() {
        return this.nbYTiles;
    }

    public int getMaxTiles() {
        return this.maxTiles;
    }

    public void setMaxTiles(int maxTiles) {
        this.maxTiles = maxTiles;
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void updateTilingInfo() {
        this.updateTilingInfo(null);
    }

    public void updateTilingInfo(final TilingInfoCallback callback) {
        RequestBuilder getRequest = new RequestBuilder(RequestBuilder.GET, this.getBaseUrl() + "?format=json");
        try {
            getRequest.sendRequest(null, new RequestCallback(){

                public void onError(Request arg0, Throwable arg1) {
                    Log.error((String)("Error sending tiling info request: " + arg1));
                }

                public void onResponseReceived(Request arg0, Response resp) {
                    TilingInfo.this.parseResponse(resp.getText());
                    if (callback != null) {
                        callback.tilingInfoUpdated();
                    }
                }
            });
        }
        catch (RequestException e) {
            Window.alert((String)("Error getting the tiling server: " + (Object)((Object)e)));
        }
    }

    public void parseResponse(String response) {
        if ("".equals(response)) {
            return;
        }
        JSONObject jsonValue = (JSONObject)JSONParser.parse((String)response);
        JSONObject tileInfo = (JSONObject)jsonValue.get("tileInfo");
        JSONObject originalImage = (JSONObject)jsonValue.get("originalImage");
        JSONNumber zoomFactor = (JSONNumber)tileInfo.get("zoom");
        JSONNumber widthJS = (JSONNumber)originalImage.get("width");
        JSONNumber heightJS = (JSONNumber)originalImage.get("height");
        JSONNumber xTilesJS = (JSONNumber)tileInfo.get("xtiles");
        JSONNumber yTilesJS = (JSONNumber)tileInfo.get("ytiles");
        JSONNumber maxTilesJS = (JSONNumber)tileInfo.get("maxtiles");
        JSONNumber tileWidthJS = (JSONNumber)tileInfo.get("tileWidth");
        JSONNumber tileHeightJS = (JSONNumber)tileInfo.get("tileHeight");
        this.zoom = zoomFactor.doubleValue();
        this.originalImageWidth = new Double(widthJS.doubleValue()).intValue();
        this.originalImageHeight = new Double(heightJS.doubleValue()).intValue();
        this.nbXTiles = new Double(xTilesJS.doubleValue()).intValue();
        this.nbYTiles = new Double(yTilesJS.doubleValue()).intValue();
        this.maxTiles = new Double(maxTilesJS.doubleValue()).intValue();
        this.tileWidth = new Double(tileWidthJS.doubleValue()).intValue();
        this.tileHeight = new Double(tileHeightJS.doubleValue()).intValue();
        JSONObject additionalInfo = (JSONObject)jsonValue.get("additionalInfo");
        JSONString lastModificationDateJS = (JSONString)additionalInfo.get("lastModificationDate");
        this.lastModificationDate = Long.parseLong(lastModificationDateJS.stringValue());
        this.initialized = true;
    }

    public String getBaseUrl() {
        return this.contextPath + "/restAPI/getTiles/" + this.getRepoId() + "/" + this.getDocId() + "/" + this.getTileWidth() + "/" + this.getTileHeight() + "/" + this.getMaxTiles();
    }
}

