/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.rendition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.ecm.platform.picture.rendition.PictureRenditionProvider;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProvider;
import org.nuxeo.runtime.api.Framework;

public class PictureRenditionDefinitionProvider
implements RenditionDefinitionProvider {
    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        MultiviewPicture multiviewPicture = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class);
        if (multiviewPicture == null) {
            return Collections.emptyList();
        }
        ArrayList<RenditionDefinition> renditionDefinitions = new ArrayList<RenditionDefinition>();
        ImagingService imagingService = (ImagingService)Framework.getService(ImagingService.class);
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        for (PictureView pictureView : multiviewPicture.getViews()) {
            Blob blob;
            PictureConversion pictureConversion = imagingService.getPictureConversion(pictureView.getTitle());
            if (pictureConversion == null || !pictureConversion.isRendition() || (blob = pictureView.getBlob()) == null) continue;
            RenditionDefinition renditionDefinition = new RenditionDefinition();
            renditionDefinition.setEnabled(true);
            renditionDefinition.setName(pictureView.getTitle());
            renditionDefinition.setProvider((RenditionProvider)new PictureRenditionProvider());
            renditionDefinition.setVisible(pictureConversion.isRenditionVisible());
            renditionDefinition.setLabel(pictureView.getTitle());
            MimetypeEntry mimeType = mimetypeRegistry.getMimetypeEntryByMimeType(blob.getMimeType());
            renditionDefinition.setIcon("/icons/" + mimeType.getIconPath());
            renditionDefinitions.add(renditionDefinition);
        }
        return renditionDefinitions;
    }
}

