/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.video.convert.BaseVideoConverter;
import org.nuxeo.runtime.api.Framework;

public class StoryboardConverter
extends BaseVideoConverter
implements Converter {
    public static final Log log = LogFactory.getLog(StoryboardConverter.class);
    public static final String FFMPEG_INFO_COMMAND = "ffmpeg-info";
    public static final String FFMPEG_SCREENSHOT_RESIZE_COMMAND = "ffmpeg-screenshot-resize";
    public static final String WIDTH_PARAM = "width";
    public static final String HEIGHT_PARAM = "height";
    public static final String THUMBNAIL_NUMBER_PARAM = "thumbnail_number";
    protected int numberOfThumbnails = 9;
    protected Map<String, String> commonParams = new HashMap<String, String>();

    public void init(ConverterDescriptor descriptor) {
        try {
            this.cleService = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return;
        }
        this.commonParams = descriptor.getParameters();
        if (!this.commonParams.containsKey(WIDTH_PARAM)) {
            this.commonParams.put(WIDTH_PARAM, "100");
        }
        if (!this.commonParams.containsKey(HEIGHT_PARAM)) {
            this.commonParams.put(HEIGHT_PARAM, "62");
        }
        if (this.commonParams.containsKey(THUMBNAIL_NUMBER_PARAM)) {
            this.numberOfThumbnails = Integer.parseInt(this.commonParams.get(THUMBNAIL_NUMBER_PARAM));
        }
        if (this.numberOfThumbnails < 1) {
            this.numberOfThumbnails = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        ArrayList<Double> timecodes = new ArrayList<Double>();
        ArrayList<String> comments = new ArrayList<String>();
        properties.put("timecodes", timecodes);
        properties.put("comments", comments);
        SimpleBlobHolderWithProperties bh = new SimpleBlobHolderWithProperties(blobs, properties);
        Blob blob = blobHolder.getBlob();
        try (CloseableFile source = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));){
            CmdParameters params = new CmdParameters();
            params.addNamedParameter("inFilePath", source.getFile().getAbsolutePath());
            Double duration = (Double)parameters.get("duration");
            if (duration == null) {
                log.warn((Object)String.format("Cannot extract storyboard for file '%s' with missing duration info.", blob.getFilename()));
                SimpleBlobHolderWithProperties simpleBlobHolderWithProperties = bh;
                return simpleBlobHolderWithProperties;
            }
            if (duration < 10.0) {
                SimpleBlobHolderWithProperties simpleBlobHolderWithProperties = bh;
                return simpleBlobHolderWithProperties;
            }
            for (int i = 0; i < this.numberOfThumbnails; ++i) {
                long timecode = Double.valueOf(Math.floor((double)i * duration / (double)this.numberOfThumbnails)).longValue();
                Blob thumbBlob = Blobs.createBlobWithExtension((String)".jpeg");
                params.addNamedParameter("outFilePath", thumbBlob.getFile().getAbsolutePath());
                params.addNamedParameter("position", String.valueOf(timecode));
                params.addNamedParameter(WIDTH_PARAM, this.commonParams.get(WIDTH_PARAM));
                params.addNamedParameter(HEIGHT_PARAM, this.commonParams.get(HEIGHT_PARAM));
                ExecResult result = this.cleService.execCommand(FFMPEG_SCREENSHOT_RESIZE_COMMAND, params);
                if (!result.isSuccessful()) {
                    throw result.getError();
                }
                thumbBlob.setMimeType("image/jpeg");
                thumbBlob.setFilename(String.format("%05d.000-seconds.jpeg", timecode));
                blobs.add(thumbBlob);
                timecodes.add(Double.valueOf(timecode));
                comments.add(String.format("%s %d", blob.getFilename(), i));
            }
            SimpleBlobHolderWithProperties simpleBlobHolderWithProperties = bh;
            return simpleBlobHolderWithProperties;
        }
        catch (IOException | ClientException | CommandException | CommandNotAvailable e) {
            String msg;
            if (blob != null) {
                msg = "Error extracting story board from '" + blob.getFilename() + "'";
                throw new ConversionException(msg, (Exception)e);
            }
            msg = "conversion failed";
            throw new ConversionException(msg, (Exception)e);
        }
    }
}

